package util.notifiers;

import models.AppUser;
import models.EmailMessage;
import models.contacts.Person;
import models.projects.Deliverable;
import models.projects.Project;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import play.Logger;
import play.Play;
import play.mvc.Mailer;
import play.templates.Template;
import play.templates.TemplateLoader;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;


public final class Email extends Mailer {

    private Email() {
    }


    public static void welcome(AppUser user) {

        setSubject("Καλωσήρθατε στη Syndromi.gr");
        addRecipient(user.userName);
        if(Play.mode.isDev())
        {
        addBcc("kellymarkou@dimicro.gr");
        addBcc("tzampazy@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user);
    }

    public static void welcomeToProject(AppUser puser, AppUser user, Project project, boolean hasAccess) {
        Template template = TemplateLoader.load("app/views/util/notifiers/Email/welcomeToProject.html");
        Map<String,Object> params = new HashMap<>();
        params.put("user",user);
        params.put("puser",puser);
        params.put("project",project);

        Logger.info("----------" +puser.firstName);
        setSubject("Έχετε μια ενημέρωση απο την εφαρμογή designero");
        addRecipient(puser.contactInfo.email);
        if(Play.mode.isDev())
        {
            //addBcc("dimitris@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user,puser,project,hasAccess);
    }

    public static void addToDeliverable(Person person, AppUser user, Deliverable deliverable, boolean hasAccess) {
        Template template = TemplateLoader.load("app/views/util/notifiers/Email/addToDeliverable.html");
        Map<String,Object> params = new HashMap<>();
        params.put("user",user);
        params.put("person",person);
        params.put("deliverable",deliverable);

        Logger.info("----------" +person.firstName);
        setSubject("Έχετε μια ενημέρωση απο την εφαρμογή designero");
        addRecipient(person.contactInfo.email);
        if(Play.mode.isDev())
        {
            addBcc("dimitris@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user,person,deliverable,hasAccess);
    }

    public static void RemoveFromProject(Person person, AppUser user, Project project) {
        Template template = TemplateLoader.load("app/views/util/notifiers/Email/RemoveFromProject.html");
        Map<String,Object> params = new HashMap<>();
        params.put("user",user);
        params.put("person",person);
        params.put("project",project);

        Logger.info("----------" +person.firstName);
        setSubject("Ενημέρωση απο την εφαρμογή designero");
        addRecipient(person.contactInfo.email);
        if(Play.mode.isDev())
        {
            addBcc("dimitris@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user,person,project);
    }

     public static void welcomeMemberEmail(Person person, AppUser user) {
         Template template = TemplateLoader.load("app/views/util/notifiers/Email/welcomeMemberEmail.html");
         Map<String,Object> params = new HashMap<>();
         params.put("user",user);
         params.put("person",person);


//         EmailMessage emailMessage = new EmailMessage(template.render(params), "Syndromi.gr - Ενεργοποίηση χρήστη", AppUser.admin());
//         emailMessage.receipients.add(member);
//         emailMessage.sendNoTemplate();
//         flash.success("Επιτυχής αποστολή πρόσκλησης");
//         Application.addMember(memberId);
        setSubject("Έχετε μια πρόσκληση για την εφαρμογή designero");
        addRecipient(person.contactInfo.email);
        if(Play.mode.isDev())
        {
        addBcc("dimitris@dimicro.gr");
        //addBcc("tzampazy@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user,person);
    }

    public static void inviteToRegister(Person puser, AppUser user) {
        Template template = TemplateLoader.load("app/views/util/notifiers/Email/inviteToRegister.html");
        Map<String,Object> params = new HashMap<>();
        params.put("user",user);
        params.put("puser",puser);

        setSubject("Έχετε μια πρόσκληση για εγγραφή στην εφαρμογή designero");
        addRecipient(puser.contactInfo.email);
        if(Play.mode.isDev())
        {
            addBcc("dimitris@dimicro.gr");
            //addBcc("tzampazy@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user,puser);
    }





    public static void resetPass(AppUser user){
        String email = user.userName;

        if(email== null || email.equals(""))
        {
            email = user.contactInfo.email;
        }
        Logger.info("resetPass ----- " +email);
        prepareResetEmail(email,false);
        boolean isAppUser=true;
        Logger.info(user.contactInfo.email);
        send(user,isAppUser);
    }



    private static void prepareResetEmail(String email, boolean isMemberUser) {
        setSubject("Aλλαγή κωδικού πρόσβασης "+(isMemberUser?"μέλους":"διαχειριστή")+" Syndromi.gr");
        Logger.info("prepareResetEmail ----- " +email);
        addRecipient(email);
        if(Play.mode.isDev())
        {
            //addBcc("kellymarkou@dimicro.gr");
            //addBcc("leonidas@dimicro.gr");
        }
        setFrom("info@syndromi.gr <info@syndromi.gr>");
    }


    public static void deactivationEmail(AppUser user){
        setSubject("Απενεργοποίηση Λογαριασμού");
        addRecipient(user.userName);
        if(Play.mode.isDev())
        addDevsBcc();
        send(user);
    }

    private static void addDevsBcc() {
        addBcc("kellymarkou@dimicro.gr");
        addBcc("tzampazy@dimicro.gr");
        addBcc("lkotoulas@dimicro.gr");
        setFrom("info@syndromi.gr <info@syndromi.gr>");
    }


    public static void deleteAccountEmail(AppUser user){
        setSubject("Διαγραφή Λογαριασμού");
        addRecipient(user.userName);
        addDevsBcc();
        send(user);
    }


    public static void verifyEmail(AppUser user) {

        setSubject("syndromi.gr - Επιβεβαίωση ηλεκτρονικής διεύθυνσης αποστολέα μηνυμάτων");
        addRecipient(user.contactInfo.replyToAddress);
        setFrom("info@syndromi.gr <info@syndromi.gr>");
        send(user);
    }

//    public static void youHavePaidEmail(AppUser user, MemberTransaction trans)
//    {
//        setSubject("syndromi.gr - Επιτυχημένη πληρωμή υπηρεσιών - " + trans.credit + "E");
//        addRecipient(trans.forMember.contactInfo.email);
//        setFrom(user.appUserParams.contactInfo.replyToAddress);
//        send(user, trans);
//    }

//    public static void subscriptionEnding(AppUser user, Set<Member> members) throws EmailAlreadySentException, UnsupportedFeatureException {
//
//        LocalDate date = new LocalDate(DateTime.now().withTimeAtStartOfDay().plusDays(5));
//        EmailMessage email = new EmailMessage(user);
//        email.receipients = members;
//        email.title = "syndromi.gr - Αυτοματοποιημένη ενημέρωση για επικείμενη λήξη συνδρομής";
//        email.appUser = user;
//        email.content = " Αγαπητέ συνδρομητή σας ενημερώνουμε πως η σύνδρομή σας στον σύλλογο "+ user.appUserParams.title + " θα λήξη στις "+ date +"<br/>Παρακαλώ μην αμελήσετε να την ανανεώσετε.";
//        email.send();
//
//
//    }

//    public static void inactiveAttendant(AppUser user, Set<Member> members) throws EmailAlreadySentException, UnsupportedFeatureException {
//        String mems = "";
//        LocalDate date = new LocalDate(DateTime.now().withTimeAtStartOfDay());
//        EmailMessage email = new EmailMessage(user);
//        email.title = "syndromi.gr - Αυτοματοποιημένη ενημέρωση για παρουσίες ανενεργών μελών";
//        email.appUser = user;
//        email.content = "Παρουσίες για <b>" +date+"</b><br/>";
//        for(Member mem : members)
//        {
//            mems +=mem.lastname+" "+mem.firstname+" "+mem.contactInfo.email+"<br/>";
//        }
//        email.content += mems;
//        email.send();
//
//    }


}