package models;

import models.contacts.Person;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.JPABase;
import play.db.jpa.Model;

import javax.persistence.Entity;
import javax.persistence.ManyToOne;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Leonidas on 10/11/2015.
 */
@Entity
public class SentStatus extends Model {

    private static final Map<String, String> statusMap;
    static {
        Map<String, String> aMap = new HashMap<>();
        aMap.put("delivered", "Παραδόθηκε");
        aMap.put("dropped", "Απέτυχε");
        aMap.put("opened", "Άνοιξε");
        aMap.put("bounced", "Απέτυχε");
        statusMap = Collections.unmodifiableMap(aMap);
    }

    @ManyToOne
    public Person person;
    @ManyToOne
    public EmailMessage emailMessage;

    public String status;

    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime dateTime = new DateTime();


    public SentStatus(Person person, EmailMessage emailMessage, String status) {
        this.person = person;
        this.emailMessage = emailMessage;
        this.status = status;
    }

    public String getStatusString(){
        return statusMap.get(status)==null?status:statusMap.get(status);
    }

    @Override
    public <T extends JPABase> T save() {
        if ("dropped".equals(status)) {
            person.contactInfo.emailBounced=true;
            person.save();
        }
        return super.save();
    }
}
