package models;


import models.contacts.Person;
import org.hibernate.annotations.Type;
import org.joda.time.DateTime;
import play.db.jpa.JPABase;
import play.db.jpa.Model;
import play.libs.WS;
import play.templates.Template;
import play.templates.TemplateLoader;
import util.notifiers.MailgunMailer;

import javax.persistence.*;
import java.util.*;

@Entity
public class EmailMessage extends Model implements Comparable<EmailMessage>{

    @Column(columnDefinition = "text")
    public String content;

    public String title;

    @ManyToOne
    public AppUser appUser;
    @ManyToMany
    public Set<Person> receipients = new HashSet<>();

    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime dateSent;
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime dateSaved;
    @Type(type = "org.jadira.usertype.dateandtime.joda.PersistentDateTime")
    public DateTime dateCreated;

    //Mailgun paramaters
    public String message_id="";

    @OneToMany(mappedBy = "emailMessage")
    public List<SentStatus> statuses= new ArrayList<>();

    public EmailMessage(AppUser appUser) {
        dateCreated=new DateTime();
        this.appUser = appUser;
    }

    public EmailMessage(String content, String title, AppUser appUser) {
        this.content = content;
        this.title = title;
        this.appUser = appUser;
    }

    @Override
    public <T extends JPABase> T save() {
        dateSaved=new DateTime();
        return super.save();
    }

    public WS.HttpResponse send() throws UnsupportedFeatureException {
        if (dateSent != null) {

        }
        dateSent=new DateTime();
        Map<String,Object> args = new HashMap<>();
        args.put("user",appUser);
        args.put("content", content);
        Template template = TemplateLoader.load("app/views/util/notifiers/Email/wrapperUserEmail.html");
        String formattedEmailContent = template.render(args);

        if (receipients.size()<1000 ) {
            return MailgunMailer.simpleText(appUser.userName+" <i"+appUser.id+"@userlists.syndromi.gr>", receipients, formattedEmailContent, title, this.id, appUser.contactInfo.replyToAddress, appUser.id);
        }
        else{
            throw new UnsupportedFeatureException("Not implemented for lists with over 1000 transactions");
        }
    }
  public WS.HttpResponse sendNoTemplate() throws UnsupportedFeatureException {

        if (receipients.size()<1000) {
            return MailgunMailer.simpleText(appUser.userName+" <i"+appUser.id+"@userlists.syndromi.gr>", receipients, content, title, this.id, appUser.contactInfo.replyToAddress, appUser.id);
        }else{
            throw new UnsupportedFeatureException("Not implemented for lists with over 1000 transactions");
        }
    }


    public static List<EmailMessage> sentToPerson(Person person){
        return EmailMessage.find("select em from EmailMessage em where :person person of em.receipients order by dateSent desc").setParameter("person",person).fetch();
    }

    @Override
    public int compareTo(EmailMessage o) {
        return this.dateSent.compareTo(o.dateSent);
    }
}
