/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.joda.columnmapper;

import org.jadira.usertype.moneyandcurrency.joda.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractLongColumnMapper;
import org.joda.money.BigMoney;
import org.joda.money.CurrencyUnit;

public class LongColumnBigMoneyMajorMapper
extends AbstractLongColumnMapper<BigMoney>
implements CurrencyUnitConfigured {
    private static final long serialVersionUID = 4205713919952452881L;
    private CurrencyUnit currencyUnit;

    public BigMoney fromNonNullValue(Long value) {
        BigMoney theMoney = BigMoney.ofMajor((CurrencyUnit)this.currencyUnit, (long)value);
        if (theMoney.getScale() < this.currencyUnit.getDecimalPlaces()) {
            theMoney = theMoney.withCurrencyScale();
        }
        return theMoney;
    }

    public Long toNonNullValue(BigMoney value) {
        if (!this.currencyUnit.equals((Object)value.getCurrencyUnit())) {
            throw new IllegalStateException("Expected currency " + this.currencyUnit.getCurrencyCode() + " but was " + value.getCurrencyUnit());
        }
        return value.toBigMoney().getAmountMajorLong();
    }

    public BigMoney fromNonNullString(String s) {
        return BigMoney.parse((String)s);
    }

    public String toNonNullString(BigMoney value) {
        return value.toString();
    }

    @Override
    public void setCurrencyUnit(CurrencyUnit currencyUnit) {
        this.currencyUnit = currencyUnit;
    }
}

