/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import org.jadira.usertype.dateandtime.joda.util.ZoneHelper;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;
import org.jadira.usertype.spi.shared.VersionableColumnMapper;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class TimestampColumnDateTimeMapper
extends AbstractVersionableTimestampColumnMapper<DateTime>
implements JavaZoneConfigured<DateTimeZone>,
VersionableColumnMapper<DateTime, Timestamp> {
    private static final long serialVersionUID = -7670411089210984705L;
    public static final DateTimeFormatter DATETIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd HH:mm:ss'.'").appendFractionOfSecond(0, 9).toFormatter();
    private DateTimeZone javaZone = null;

    public TimestampColumnDateTimeMapper() {
    }

    public TimestampColumnDateTimeMapper(DateTimeZone javaZone) {
        this.javaZone = javaZone;
    }

    public DateTime fromNonNullString(String s) {
        return new DateTime((Object)s);
    }

    public DateTime fromNonNullValue(Timestamp value) {
        DateTimeZone currentJavaZone = this.javaZone == null ? ZoneHelper.getDefault() : this.javaZone;
        DateTime dateTime = DATETIME_FORMATTER.parseDateTime(value.toString());
        return dateTime.withZone(currentJavaZone);
    }

    public String toNonNullString(DateTime value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(DateTime value) {
        Timestamp timestamp = new Timestamp(value.getMillis());
        return timestamp;
    }

    public void setJavaZone(DateTimeZone javaZone) {
        this.javaZone = javaZone;
    }

    public DateTimeZone parseJavaZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }
}

