/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.verify.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.verify.v1.service.VerificationCheck;

public class VerificationCheckCreator
extends Creator<VerificationCheck> {
    private final String pathServiceSid;
    private final String code;
    private String to;
    private String verificationSid;

    public VerificationCheckCreator(String pathServiceSid, String code) {
        this.pathServiceSid = pathServiceSid;
        this.code = code;
    }

    public VerificationCheckCreator setTo(String to) {
        this.to = to;
        return this;
    }

    public VerificationCheckCreator setVerificationSid(String verificationSid) {
        this.verificationSid = verificationSid;
        return this;
    }

    @Override
    public VerificationCheck create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.VERIFY.toString(), "/v1/Services/" + this.pathServiceSid + "/VerificationCheck", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("VerificationCheck creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return VerificationCheck.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.code != null) {
            request.addPostParam("Code", this.code);
        }
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.verificationSid != null) {
            request.addPostParam("VerificationSid", this.verificationSid);
        }
    }
}

