/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.accSecurity.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.accSecurity.service.Verification;

public class VerificationCreator
extends Creator<Verification> {
    private final String pathServiceSid;
    private final String to;
    private final String channel;
    private String customMessage;

    public VerificationCreator(String pathServiceSid, String to, String channel) {
        this.pathServiceSid = pathServiceSid;
        this.to = to;
        this.channel = channel;
    }

    public VerificationCreator setCustomMessage(String customMessage) {
        this.customMessage = customMessage;
        return this;
    }

    @Override
    public Verification create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Verification/Services/" + this.pathServiceSid + "/Verifications", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Verification creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Verification.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.channel != null) {
            request.addPostParam("Channel", this.channel);
        }
        if (this.customMessage != null) {
            request.addPostParam("CustomMessage", this.customMessage);
        }
    }
}

