/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.twilio.http.Request;
import com.twilio.http.Response;

public abstract class HttpClient {
    public static final int ANY_500 = -500;
    public static final int ANY_400 = -400;
    public static final int ANY_300 = -300;
    public static final int ANY_200 = -200;
    public static final int ANY_100 = -100;
    public static final int[] RETRY_CODES = new int[]{-500};
    public static final int RETRIES = 3;
    public static final long DELAY_MILLIS = 100L;
    private Response lastResponse;
    private Request lastRequest;

    public Response reliableRequest(Request request) {
        return this.reliableRequest(request, RETRY_CODES, 3, 100L);
    }

    public Response reliableRequest(Request request, int[] retryCodes, int retries, long delayMillis) {
        this.lastRequest = request;
        Response response = null;
        while (retries > 0 && this.shouldRetry(response = this.makeRequest(request), retryCodes)) {
            try {
                Thread.sleep(delayMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            --retries;
        }
        this.lastResponse = response;
        return response;
    }

    public Response getLastResponse() {
        return this.lastResponse;
    }

    public Request getLastRequest() {
        return this.lastRequest;
    }

    protected boolean shouldRetry(Response response, int[] retryCodes) {
        if (response == null) {
            return true;
        }
        int statusCode = response.getStatusCode();
        int category = (int)Math.floor((double)statusCode / 100.0);
        block7: for (int retryCode : retryCodes) {
            switch (retryCode) {
                case -100: {
                    if (category != 1) continue block7;
                    return true;
                }
                case -200: {
                    if (category != 2) continue block7;
                    return true;
                }
                case -300: {
                    if (category != 3) continue block7;
                    return true;
                }
                case -400: {
                    if (category != 4) continue block7;
                    return true;
                }
                case -500: {
                    if (category != 5) continue block7;
                    return true;
                }
                default: {
                    if (statusCode != retryCode) continue block7;
                    return true;
                }
            }
        }
        return false;
    }

    public abstract Response makeRequest(Request var1);
}

