/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.util.io;

import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.package$;
import org.apache.spark.network.buffer.ManagedBuffer;
import org.apache.spark.network.util.ByteArrayWritableChannel;
import org.apache.spark.storage.StorageUtils$;
import org.apache.spark.util.io.ChunkedByteBuffer$;
import org.apache.spark.util.io.ChunkedByteBufferFileRegion;
import org.apache.spark.util.io.ChunkedByteBufferInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005mc!B\u0001\u0003\u0001\u0019a!!E\"ik:\\W\r\u001a\"zi\u0016\u0014UO\u001a4fe*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sON\u0011\u0001!\u0004\t\u0003\u001dEi\u0011a\u0004\u0006\u0002!\u0005)1oY1mC&\u0011!c\u0004\u0002\u0007\u0003:L(+\u001a4\t\u0011Q\u0001!\u00111A\u0005\u0002Y\taa\u00195v].\u001c8\u0001A\u000b\u0002/A\u0019a\u0002\u0007\u000e\n\u0005ey!!B!se\u0006L\bCA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\rq\u0017n\u001c\u0006\u0002?\u0005!!.\u0019<b\u0013\t\tCD\u0001\u0006CsR,')\u001e4gKJD\u0001b\t\u0001\u0003\u0002\u0004%\t\u0001J\u0001\u000bG\",hn[:`I\u0015\fHCA\u0013)!\tqa%\u0003\u0002(\u001f\t!QK\\5u\u0011\u001dI#%!AA\u0002]\t1\u0001\u001f\u00132\u0011!Y\u0003A!A!B\u00139\u0012aB2ik:\\7\u000f\t\u0005\u0006[\u0001!\tAL\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005=\n\u0004C\u0001\u0019\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b-\u0001\u00049\u0002bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\u0015EV4g-\u001a:Xe&$Xm\u00115v].\u001c\u0016N_3\u0016\u0003U\u0002\"A\u0004\u001c\n\u0005]z!aA%oi\"1\u0011\b\u0001Q\u0001\nU\nQCY;gM\u0016\u0014xK]5uK\u000eCWO\\6TSj,\u0007\u0005\u0003\u0004<\u0001\u0001\u0006K\u0001P\u0001\tI&\u001c\bo\\:fIB\u0011a\"P\u0005\u0003}=\u0011qAQ8pY\u0016\fg\u000eC\u0004A\u0001\t\u0007I\u0011A!\u0002\tML'0Z\u000b\u0002\u0005B\u0011abQ\u0005\u0003\t>\u0011A\u0001T8oO\"1a\t\u0001Q\u0001\n\t\u000bQa]5{K\u0002BQ!\f\u0001\u0005\u0002!#\"aL%\t\u000b);\u0005\u0019\u0001\u000e\u0002\u0015\tLH/\u001a\"vM\u001a,'\u000fC\u0003M\u0001\u0011\u0005Q*\u0001\u0006xe&$XMR;mYf$\"!\n(\t\u000b=[\u0005\u0019\u0001)\u0002\u000f\rD\u0017M\u001c8fYB\u0011\u0011\u000bV\u0007\u0002%*\u00111\u000bH\u0001\tG\"\fgN\\3mg&\u0011QK\u0015\u0002\u0014/JLG/\u00192mK\nKH/Z\"iC:tW\r\u001c\u0005\u0006/\u0002!\t\u0001W\u0001\bi>tU\r\u001e;z+\u0005I\u0006C\u0001\u0019[\u0013\tY&AA\u000eDQVt7.\u001a3CsR,')\u001e4gKJ4\u0015\u000e\\3SK\u001eLwN\u001c\u0005\u0006;\u0002!\tAX\u0001\bi>\f%O]1z+\u0005y\u0006c\u0001\b\u0019AB\u0011a\"Y\u0005\u0003E>\u0011AAQ=uK\")A\r\u0001C\u0001K\u0006aAo\u001c\"zi\u0016\u0014UO\u001a4feV\t!\u0004C\u0003h\u0001\u0011\u0005\u0001.A\u0007u_&s\u0007/\u001e;TiJ,\u0017-\u001c\u000b\u0003S:\u0004\"A\u001b7\u000e\u0003-T!a\u0001\u0010\n\u00055\\'aC%oaV$8\u000b\u001e:fC6Dqa\u001c4\u0011\u0002\u0003\u0007A(A\u0004eSN\u0004xn]3\t\u000bE\u0004A\u0011\u0001:\u0002\u0013\u001d,Go\u00115v].\u001cH#A\f\t\u000bQ\u0004A\u0011A;\u0002\t\r|\u0007/\u001f\u000b\u0003_YDQa^:A\u0002a\f\u0011\"\u00197m_\u000e\fGo\u001c:\u0011\t9IXGG\u0005\u0003u>\u0011\u0011BR;oGRLwN\\\u0019\t\u000b=\u0004A\u0011\u0001?\u0015\u0003\u0015BqA \u0001\u0012\u0002\u0013\u0005q0A\fu_&s\u0007/\u001e;TiJ,\u0017-\u001c\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0001\u0016\u0004y\u0005\r1FAA\u0003!\u0011\t9!!\u0005\u000e\u0005\u0005%!\u0002BA\u0006\u0003\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=q\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0005\u0002\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u0011\u0005]!\u0001#\u0001\u0007\u00033\t\u0011c\u00115v].,GMQ=uK\n+hMZ3s!\r\u0001\u00141\u0004\u0004\b\u0003\tA\tABA\u000f'\r\tY\"\u0004\u0005\b[\u0005mA\u0011AA\u0011)\t\tI\u0002\u0003\u0005\u0002&\u0005mA\u0011AA\u0014\u0003E1'o\\7NC:\fw-\u001a3Ck\u001a4WM\u001d\u000b\u0004_\u0005%\u0002\u0002CA\u0016\u0003G\u0001\r!!\f\u0002\t\u0011\fG/\u0019\t\u0005\u0003_\tI$\u0004\u0002\u00022)!\u00111GA\u001b\u0003\u0019\u0011WO\u001a4fe*\u0019\u0011q\u0007\u0004\u0002\u000f9,Go^8sW&!\u00111HA\u0019\u00055i\u0015M\\1hK\u0012\u0014UO\u001a4fe\"A\u0011qHA\u000e\t\u0003\t\t%\u0001\u0005ge>lg)\u001b7f)\ry\u00131\t\u0005\t\u0003\u000b\ni\u00041\u0001\u0002H\u0005!a-\u001b7f!\rQ\u0017\u0011J\u0005\u0004\u0003\u0017Z'\u0001\u0002$jY\u0016D\u0001\"a\u0010\u0002\u001c\u0011%\u0011q\n\u000b\b_\u0005E\u00131KA,\u0011!\t)%!\u0014A\u0002\u0005\u001d\u0003bBA+\u0003\u001b\u0002\rAQ\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005e\u0013Q\na\u0001\u0005\u00061A.\u001a8hi\"\u0004")
public class ChunkedByteBuffer {
    private ByteBuffer[] chunks;
    private final int bufferWriteChunkSize;
    private boolean disposed;
    private final long size;

    public static ChunkedByteBuffer fromFile(File file) {
        return ChunkedByteBuffer$.MODULE$.fromFile(file);
    }

    public static ChunkedByteBuffer fromManagedBuffer(ManagedBuffer managedBuffer) {
        return ChunkedByteBuffer$.MODULE$.fromManagedBuffer(managedBuffer);
    }

    public ByteBuffer[] chunks() {
        return this.chunks;
    }

    public void chunks_$eq(ByteBuffer[] x$1) {
        this.chunks = x$1;
    }

    private int bufferWriteChunkSize() {
        return this.bufferWriteChunkSize;
    }

    public long size() {
        return this.size;
    }

    public void writeFully(WritableByteChannel channel) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).foreach((Function1 & Serializable & scala.Serializable)bytes -> {
            ChunkedByteBuffer.$anonfun$writeFully$1(this, channel, bytes);
            return BoxedUnit.UNIT;
        });
    }

    public ChunkedByteBufferFileRegion toNetty() {
        return new ChunkedByteBufferFileRegion(this, this.bufferWriteChunkSize());
    }

    public byte[] toArray() {
        if (this.size() >= Integer.MAX_VALUE) {
            throw new UnsupportedOperationException(new StringBuilder(75).append("cannot call toArray because buffer size (").append(this.size()).append(" bytes) exceeds maximum array size").toString());
        }
        ByteArrayWritableChannel byteChannel = new ByteArrayWritableChannel((int)this.size());
        this.writeFully((WritableByteChannel)byteChannel);
        byteChannel.close();
        return byteChannel.getData();
    }

    public ByteBuffer toByteBuffer() {
        return this.chunks().length == 1 ? ((ByteBuffer)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).head()).duplicate() : ByteBuffer.wrap(this.toArray());
    }

    public InputStream toInputStream(boolean dispose) {
        return new ChunkedByteBufferInputStream(this, dispose);
    }

    public boolean toInputStream$default$1() {
        return false;
    }

    public ByteBuffer[] getChunks() {
        return (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.duplicate(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
    }

    public ChunkedByteBuffer copy(Function1<Object, ByteBuffer> allocator) {
        ByteBuffer[] copiedChunks = (ByteBuffer[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.getChunks())).map((Function1 & Serializable & scala.Serializable)chunk -> {
            void var2_2;
            ByteBuffer newChunk = (ByteBuffer)allocator.apply((Object)BoxesRunTime.boxToInteger((int)chunk.limit()));
            newChunk.put((ByteBuffer)chunk);
            newChunk.flip();
            return var2_2;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ByteBuffer.class)));
        return new ChunkedByteBuffer(copiedChunks);
    }

    public void dispose() {
        block0: {
            if (this.disposed) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).foreach((Function1 & Serializable & scala.Serializable)buffer -> {
                StorageUtils$.MODULE$.dispose(buffer);
                return BoxedUnit.UNIT;
            });
            this.disposed = true;
        }
    }

    public static final /* synthetic */ boolean $anonfun$new$3(ByteBuffer x$1) {
        return x$1.position() == 0;
    }

    public static final /* synthetic */ long $anonfun$bufferWriteChunkSize$1(SparkEnv x$2) {
        return BoxesRunTime.unboxToLong((Object)x$2.conf().get(package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE()));
    }

    public static final /* synthetic */ void $anonfun$writeFully$1(ChunkedByteBuffer $this, WritableByteChannel channel$1, ByteBuffer bytes) {
        int originalLimit = bytes.limit();
        while (bytes.hasRemaining()) {
            int ioSize = Math.min(bytes.remaining(), $this.bufferWriteChunkSize());
            bytes.limit(bytes.position() + ioSize);
            channel$1.write(bytes);
            bytes.limit(originalLimit);
        }
    }

    public ChunkedByteBuffer(ByteBuffer[] chunks) {
        this.chunks = chunks;
        Predef$.MODULE$.require(this.chunks() != null, (Function0 & Serializable & scala.Serializable)() -> "chunks must not be null");
        Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ChunkedByteBuffer.$anonfun$new$3(x$1))), (Function0 & Serializable & scala.Serializable)() -> "chunks' positions must be 0");
        this.bufferWriteChunkSize = (int)BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)ChunkedByteBuffer.$anonfun$bufferWriteChunkSize$1(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)package$.MODULE$.BUFFER_WRITE_CHUNK_SIZE().defaultValue().get())));
        this.disposed = false;
        this.size = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.chunks())).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.limit()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public ChunkedByteBuffer(ByteBuffer byteBuffer) {
        this((ByteBuffer[])((Object[])new ByteBuffer[]{byteBuffer}));
    }
}

