/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status.api.v1;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.status.api.v1.ApiRequestContext;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.BadParameterException;
import org.apache.spark.status.api.v1.BaseAppResource;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.NotFoundException;
import org.apache.spark.status.api.v1.OneApplicationAttemptResource;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ServiceUnavailable;
import org.apache.spark.status.api.v1.StagesResource;
import org.apache.spark.status.api.v1.ThreadStackTrace;
import org.apache.spark.status.api.v1.UIRoot;
import org.apache.spark.ui.SparkUI;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005uf!B\u0001\u0003\u0001\tq!aG!cgR\u0014\u0018m\u0019;BaBd\u0017nY1uS>t'+Z:pkJ\u001cWM\u0003\u0002\u0004\t\u0005\u0011a/\r\u0006\u0003\u000b\u0019\t1!\u00199j\u0015\t9\u0001\"\u0001\u0004ti\u0006$Xo\u001d\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sON\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t1r#D\u0001\u0003\u0013\tA\"AA\bCCN,\u0017\t\u001d9SKN|WO]2f\u0011\u0015Q\u0002\u0001\"\u0001\u001d\u0003\u0019a\u0014N\\5u}\r\u0001A#A\u000f\u0011\u0005Y\u0001\u0001\"B\u0010\u0001\t\u0003\u0001\u0013\u0001\u00036pENd\u0015n\u001d;\u0015\u0005\u0005\u0002\u0004c\u0001\u0012+[9\u00111\u0005\u000b\b\u0003I\u001dj\u0011!\n\u0006\u0003Mm\ta\u0001\u0010:p_Rt\u0014\"\u0001\n\n\u0005%\n\u0012a\u00029bG.\fw-Z\u0005\u0003W1\u00121aU3r\u0015\tI\u0013\u0003\u0005\u0002\u0017]%\u0011qF\u0001\u0002\b\u0015>\u0014G)\u0019;b\u0011\u0015\td\u00041\u00013\u0003!\u0019H/\u0019;vg\u0016\u001c\bcA\u001a9u5\tAG\u0003\u00026m\u0005!Q\u000f^5m\u0015\u00059\u0014\u0001\u00026bm\u0006L!!\u000f\u001b\u0003\t1K7\u000f\u001e\t\u0003wqj\u0011\u0001C\u0005\u0003{!\u0011!CS8c\u000bb,7-\u001e;j_:\u001cF/\u0019;vg\"\"\u0001gP%K!\t\u0001u)D\u0001B\u0015\t\u00115)\u0001\u0002sg*\u0011A)R\u0001\u0003oNT\u0011AR\u0001\u0006U\u00064\u0018\r_\u0005\u0003\u0011\u0006\u0013!\"U;fef\u0004\u0016M]1n\u0003\u00151\u0018\r\\;fC\u00059\u0001\u0006\u0002\u0010M\u0013>\u0003\"\u0001Q'\n\u00059\u000b%\u0001\u0002)bi\"\f\u0013\u0001U\u0001\u0005U>\u00147\u000f\u000b\u0002\u001f%B\u0011\u0001iU\u0005\u0003)\u0006\u00131aR#U\u0011\u00151\u0006\u0001\"\u0001X\u0003\u0019yg.\u001a&pER\u0011Q\u0006\u0017\u0005\u00063V\u0003\rAW\u0001\u0006U>\u0014\u0017\n\u001a\t\u0003!mK!\u0001X\t\u0003\u0007%sG\u000f\u000b\u0003Y=&\u000b\u0007C\u0001!`\u0013\t\u0001\u0017IA\u0005QCRD\u0007+\u0019:b[\u0006\n\u0011\f\u000b\u0003V\u0019&\u001b\u0017%\u00013\u0002#)|'m]\u0018|U>\u0014\u0017\n\u001a\u001e!9\u0012\\S\u0010\u000b\u0002V%\")q\r\u0001C\u0001Q\u0006aQ\r_3dkR|'\u000fT5tiR\t\u0011\u000eE\u0002#U)\u0004\"AF6\n\u00051\u0014!aD#yK\u000e,Ho\u001c:Tk6l\u0017M]=)\t\u0019d\u0015J\\\u0011\u0002_\u0006IQ\r_3dkR|'o\u001d\u0015\u0003MJCQA\u001d\u0001\u0005\u0002M\f!\u0002\u001e5sK\u0006$G)^7q)\t!(\u0010E\u0002\u0011k^L!A^\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005YA\u0018BA=\u0003\u0005A!\u0006N]3bIN#\u0018mY6Ue\u0006\u001cW\rC\u0003|c\u0002\u0007A0\u0001\u0004fq\u0016\u001c\u0017\n\u001a\t\u0004{\u0006\raB\u0001@\u0000!\t!\u0013#C\u0002\u0002\u0002E\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0003\u0003\u000f\u0011aa\u0015;sS:<'bAA\u0001#!*!PX%\u0002\f\u0005\u0012\u0011QB\u0001\u000bKb,7-\u001e;pe&#\u0007&B9M\u0013\u0006E\u0011EAA\n\u0003y)\u00070Z2vi>\u00148oL>fq\u0016\u001cW\u000f^8s\u0013\u0012lx\u0006\u001e5sK\u0006$7\u000f\u000b\u0002r%\"1\u0011\u0011\u0004\u0001\u0005\u0002!\fq\"\u00197m\u000bb,7-\u001e;pe2K7\u000f\u001e\u0015\u0007\u0003/a\u0015*!\b\"\u0005\u0005}\u0011\u0001D1mY\u0016DXmY;u_J\u001c\bfAA\f%\"9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0012AB:uC\u001e,7\u000f\u0006\u0002\u0002*A)Q0a\u000b\u00020%!\u0011QFA\u0004\u0005\u0015\u0019E.Y:t!\r1\u0012\u0011G\u0005\u0004\u0003g\u0011!AD*uC\u001e,7OU3t_V\u00148-\u001a\u0015\u0007\u0003Ga\u0015*a\u000e\"\u0005\u0005\u0015\u0002bBA\u001e\u0001\u0011\u0005\u0011QH\u0001\be\u0012$G*[:u)\t\ty\u0004\u0005\u0003#U\u0005\u0005\u0003c\u0001\f\u0002D%\u0019\u0011Q\t\u0002\u0003\u001dI#Ei\u0015;pe\u0006<W-\u00138g_\"2\u0011\u0011\b'J\u0003\u0013\n#!a\u0013\u0002\u0017M$xN]1hK>\u0012H\r\u001a\u0015\u0004\u0003s\u0011\u0006bBA)\u0001\u0011\u0005\u00111K\u0001\be\u0012$G)\u0019;b)\u0011\t\t%!\u0016\t\u000f\u0005]\u0013q\na\u00015\u0006)!\u000f\u001a3JI\"2\u0011Q\u000b0J\u00037\n#!a\u0016)\r\u0005=C*SA0C\t\t\t'\u0001\rti>\u0014\u0018mZ30e\u0012$wf\u001f:eI&#'\b\t/eWuD3!a\u0014S\u0011\u001d\t9\u0007\u0001C\u0001\u0003S\nq\"\u001a8wSJ|g.\\3oi&sgm\u001c\u000b\u0003\u0003W\u00022AFA7\u0013\r\tyG\u0001\u0002\u001b\u0003B\u0004H.[2bi&|g.\u00128wSJ|g.\\3oi&sgm\u001c\u0015\u0007\u0003Kb\u0015*a\u001d\"\u0005\u0005U\u0014aC3om&\u0014xN\\7f]RD3!!\u001aS\u0011\u001d\tY\b\u0001C\u0001\u0003{\nAbZ3u\u000bZ,g\u000e\u001e'pON$\"!a \u0011\t\u0005\u0005\u0015qQ\u0007\u0003\u0003\u0007S1!!\"B\u0003\u0011\u0019wN]3\n\t\u0005%\u00151\u0011\u0002\t%\u0016\u001c\bo\u001c8tK\":\u0011\u0011PAG\u0013\u0006M\u0005c\u0001!\u0002\u0010&\u0019\u0011\u0011S!\u0003\u0011A\u0013x\u000eZ;dKNd#!!&\"\u0005\u0005]\u0015\u0001G1qa2L7-\u0019;j_:|sn\u0019;fi6\u001aHO]3b[\"2\u0011\u0011\u0010'J\u00037\u000b#!!(\u0002\t1|wm\u001d\u0015\u0004\u0003s\u0012\u0006bBAR\u0001\u0011\u0005\u0011QU\u0001\u0013CB\u0004H.[2bi&|g.\u0011;uK6\u0004H\u000f\u0006\u0002\u0002(B)Q0a\u000b\u0002*B\u0019a#a+\n\u0007\u00055&AA\u000fP]\u0016\f\u0005\u000f\u001d7jG\u0006$\u0018n\u001c8BiR,W\u000e\u001d;SKN|WO]2fQ\u0019\t\t\u000bT%\u00022\u0006\u0012\u00111W\u0001\fw\u0006$H/Z7qi&#W\u0010\u000b\u0004\u0001\u0003\u001bK\u0015q\u0017\u0017\u0003\u0003s\u000b#!a/\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0007")
public class AbstractApplicationResource
implements BaseAppResource {
    @PathParam(value="appId")
    private String appId;
    @PathParam(value="attemptId")
    private String attemptId;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public <T> T withUI(Function1<SparkUI, T> fn) {
        return (T)BaseAppResource.withUI$(this, fn);
    }

    @Override
    public UIRoot uiRoot() {
        return ApiRequestContext.uiRoot$(this);
    }

    @Override
    public String appId() {
        return this.appId;
    }

    @Override
    public void appId_$eq(String x$1) {
        this.appId = x$1;
    }

    @Override
    public String attemptId() {
        return this.attemptId;
    }

    @Override
    public void attemptId_$eq(String x$1) {
        this.attemptId = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @GET
    @Path(value="jobs")
    public Seq<JobData> jobsList(@QueryParam(value="status") List<JobExecutionStatus> statuses) {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$1 -> x$1.store().jobsList(statuses));
    }

    @GET
    @Path(value="jobs/{jobId: \\d+}")
    public JobData oneJob(@PathParam(value="jobId") int jobId) {
        return (JobData)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            JobData jobData;
            try {
                jobData = ui.store().job(jobId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(13).append("unknown job: ").append(jobId).toString());
            }
            return jobData;
        });
    }

    @GET
    @Path(value="executors")
    public Seq<ExecutorSummary> executorList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$2 -> x$2.store().executorList(true));
    }

    @GET
    @Path(value="executors/{executorId}/threads")
    public ThreadStackTrace[] threadDump(@PathParam(value="executorId") String execId) {
        return (ThreadStackTrace[])this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            ThreadStackTrace[] safeThreadDump;
            SparkContext safeSparkContext;
            block6: {
                boolean bl;
                block5: {
                    String string = execId;
                    String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
                    if ((string == null ? string2 != null : !string.equals(string2)) && !new StringOps(Predef$.MODULE$.augmentString(execId)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractApplicationResource.$anonfun$threadDump$2(BoxesRunTime.unboxToChar((Object)x$1))))) {
                        throw new BadParameterException(new StringBuilder(42).append("Invalid executorId: neither '").append(SparkContext$.MODULE$.DRIVER_IDENTIFIER()).append("' nor number.").toString());
                    }
                    safeSparkContext = (SparkContext)ui.sc().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                        throw new ServiceUnavailable("Thread dumps not available through the history server.");
                    });
                    bl = false;
                    Some some = null;
                    Option option = ui.store().asOption((Function0 & Serializable & scala.Serializable)() -> ui.store().executorSummary(execId));
                    if (!(option instanceof Some)) break block5;
                    bl = true;
                    some = (Some)option;
                    ExecutorSummary executorSummary = (ExecutorSummary)some.value();
                    if (executorSummary.isActive()) break block6;
                }
                if (bl) {
                    throw new BadParameterException("Executor is not active.");
                }
                throw new NotFoundException("Executor does not exist.");
            }
            ThreadStackTrace[] threadStackTraceArray = safeThreadDump = (ThreadStackTrace[])safeSparkContext.getExecutorThreadDump(execId).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new NotFoundException("No thread dump is available.");
            });
            return threadStackTraceArray;
        });
    }

    @GET
    @Path(value="allexecutors")
    public Seq<ExecutorSummary> allExecutorList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$3 -> x$3.store().executorList(false));
    }

    @Path(value="stages")
    public Class<StagesResource> stages() {
        return StagesResource.class;
    }

    @GET
    @Path(value="storage/rdd")
    public Seq<RDDStorageInfo> rddList() {
        return (Seq)this.withUI((Function1 & Serializable & scala.Serializable)x$4 -> x$4.store().rddList(x$4.store().rddList$default$1()));
    }

    @GET
    @Path(value="storage/rdd/{rddId: \\d+}")
    public RDDStorageInfo rddData(@PathParam(value="rddId") int rddId) {
        return (RDDStorageInfo)this.withUI((Function1 & Serializable & scala.Serializable)ui -> {
            RDDStorageInfo rDDStorageInfo;
            try {
                rDDStorageInfo = ui.store().rdd(rddId);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new NotFoundException(new StringBuilder(19).append("no rdd found w/ id ").append(rddId).toString());
            }
            return rDDStorageInfo;
        });
    }

    @GET
    @Path(value="environment")
    public ApplicationEnvironmentInfo environmentInfo() {
        return (ApplicationEnvironmentInfo)this.withUI((Function1 & Serializable & scala.Serializable)x$5 -> x$5.store().environmentInfo());
    }

    @Produces(value={"application/octet-stream"})
    @GET
    @Path(value="logs")
    public Response getEventLogs() {
        Response response;
        Object object;
        try {
            object = this.withUI((Function1 & Serializable & scala.Serializable)x$6 -> {
                AbstractApplicationResource.$anonfun$getEventLogs$1(x$6);
                return BoxedUnit.UNIT;
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (!(throwable2 instanceof NotFoundException) || this.attemptId() != null) {
                throw throwable;
            }
            this.attemptId_$eq("1");
            this.withUI((Function1 & Serializable & scala.Serializable)x$7 -> {
                AbstractApplicationResource.$anonfun$getEventLogs$2(x$7);
                return BoxedUnit.UNIT;
            });
            this.attemptId_$eq(null);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            object = BoxedUnit.UNIT;
        }
        try {
            String fileName = this.attemptId() != null ? new StringBuilder(15).append("eventLogs-").append(this.appId()).append("-").append(this.attemptId()).append(".zip").toString() : new StringBuilder(14).append("eventLogs-").append(this.appId()).append(".zip").toString();
            StreamingOutput stream = new StreamingOutput(this){
                private final /* synthetic */ AbstractApplicationResource $outer;

                public void write(OutputStream output) {
                    try (ZipOutputStream zipStream = new ZipOutputStream(output);){
                        this.$outer.uiRoot().writeEventLogs(this.$outer.appId(), (Option<String>)Option$.MODULE$.apply((Object)this.$outer.attemptId()), zipStream);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            response = Response.ok((Object)stream).header("Content-Disposition", (Object)new StringBuilder(21).append("attachment; filename=").append(fileName).toString()).header("Content-Type", (Object)"application/octet-stream").build();
        }
        catch (Throwable throwable) {
            Throwable throwable3 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable3);
            if (!option.isEmpty()) {
                throw new ServiceUnavailable(new StringBuilder(39).append("Event logs are not available for app: ").append(this.appId()).append(".").toString());
            }
            throw throwable;
        }
        return response;
    }

    @Path(value="{attemptId}")
    public Class<OneApplicationAttemptResource> applicationAttempt() {
        if (this.attemptId() != null) {
            throw new NotFoundException(this.httpRequest().getRequestURI());
        }
        return OneApplicationAttemptResource.class;
    }

    public static final /* synthetic */ boolean $anonfun$threadDump$2(char x$1) {
        return Character.isDigit(x$1);
    }

    public static final /* synthetic */ void $anonfun$getEventLogs$1(SparkUI x$6) {
    }

    public static final /* synthetic */ void $anonfun$getEventLogs$2(SparkUI x$7) {
    }

    public AbstractApplicationResource() {
        ApiRequestContext.$init$(this);
        BaseAppResource.$init$(this);
    }
}

