/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.Pool;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulableBuilder;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001df!B\u0001\u0003\u0001\u0011Q!A\u0006$bSJ\u001c6\r[3ek2\f'\r\\3Ck&dG-\u001a:\u000b\u0005\r!\u0011!C:dQ\u0016$W\u000f\\3s\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0003\u0002\u0001\f#U\u0001\"\u0001D\b\u000e\u00035Q\u0011AD\u0001\u0006g\u000e\fG.Y\u0005\u0003!5\u0011a!\u00118z%\u00164\u0007C\u0001\n\u0014\u001b\u0005\u0011\u0011B\u0001\u000b\u0003\u0005I\u00196\r[3ek2\f'\r\\3Ck&dG-\u001a:\u0011\u0005YIR\"A\f\u000b\u0005a!\u0011\u0001C5oi\u0016\u0014h.\u00197\n\u0005i9\"a\u0002'pO\u001eLgn\u001a\u0005\t9\u0001\u0011)\u0019!C\u0001=\u0005A!o\\8u!>|Gn\u0001\u0001\u0016\u0003}\u0001\"A\u0005\u0011\n\u0005\u0005\u0012!\u0001\u0002)p_2D\u0001b\t\u0001\u0003\u0002\u0003\u0006IaH\u0001\ne>|G\u000fU8pY\u0002B\u0001\"\n\u0001\u0003\u0002\u0003\u0006IAJ\u0001\u0005G>tg\r\u0005\u0002(Q5\tA!\u0003\u0002*\t\tI1\u000b]1sW\u000e{gN\u001a\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00075rs\u0006\u0005\u0002\u0013\u0001!)AD\u000ba\u0001?!)QE\u000ba\u0001M!9\u0011\u0007\u0001b\u0001\n\u0003\u0011\u0014AI*D\u0011\u0016#U\u000bT#S?\u0006cEjT\"B)&{ej\u0018$J\u0019\u0016{\u0006KU(Q\u000bJ#\u0016,F\u00014!\t!\u0014(D\u00016\u0015\t1t'\u0001\u0003mC:<'\"\u0001\u001d\u0002\t)\fg/Y\u0005\u0003uU\u0012aa\u0015;sS:<\u0007B\u0002\u001f\u0001A\u0003%1'A\u0012T\u0007\"+E)\u0016'F%~\u000bE\nT(D\u0003RKuJT0G\u00132+u\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u000fy\u0002!\u0019!C\u0001\u007f\u0005\u00112o\u00195fIVdWM]!mY>\u001cg)\u001b7f+\u0005\u0001\u0005c\u0001\u0007B\u0007&\u0011!)\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0011[eBA#J!\t1U\"D\u0001H\u0015\tAU$\u0001\u0004=e>|GOP\u0005\u0003\u00156\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001eM\u0015\tQU\u0002\u0003\u0004O\u0001\u0001\u0006I\u0001Q\u0001\u0014g\u000eDW\rZ;mKJ\fE\u000e\\8d\r&dW\r\t\u0005\b!\u0002\u0011\r\u0011\"\u00013\u0003Y!UIR!V\u0019R{6k\u0011%F\tVcUIU0G\u00132+\u0005B\u0002*\u0001A\u0003%1'A\fE\u000b\u001a\u000bU\u000b\u0014+`'\u000eCU\tR+M\u000bJ{f)\u0013'FA!9A\u000b\u0001b\u0001\n\u0003\u0011\u0014!\u0007$B\u0013J{6k\u0011%F\tVcUIU0Q%>\u0003VI\u0015+J\u000bNCaA\u0016\u0001!\u0002\u0013\u0019\u0014A\u0007$B\u0013J{6k\u0011%F\tVcUIU0Q%>\u0003VI\u0015+J\u000bN\u0003\u0003b\u0002-\u0001\u0005\u0004%\tAM\u0001\u0012\t\u00163\u0015)\u0016'U?B{u\nT0O\u00036+\u0005B\u0002.\u0001A\u0003%1'\u0001\nE\u000b\u001a\u000bU\u000b\u0014+`!>{Ej\u0018(B\u001b\u0016\u0003\u0003b\u0002/\u0001\u0005\u0004%\tAM\u0001\u0018\u001b&s\u0015*T+N?NC\u0015IU#T?B\u0013v\nU#S)fCaA\u0018\u0001!\u0002\u0013\u0019\u0014\u0001G'J\u001d&kU+T0T\u0011\u0006\u0013ViU0Q%>\u0003VI\u0015+ZA!9\u0001\r\u0001b\u0001\n\u0003\u0011\u0014\u0001G*D\u0011\u0016#U\u000bT%O\u000f~ku\nR#`!J{\u0005+\u0012*U3\"1!\r\u0001Q\u0001\nM\n\u0011dU\"I\u000b\u0012+F*\u0013(H?6{E)R0Q%>\u0003VI\u0015+ZA!9A\r\u0001b\u0001\n\u0003\u0011\u0014aD,F\u0013\u001eCEk\u0018)S\u001fB+%\u000bV-\t\r\u0019\u0004\u0001\u0015!\u00034\u0003A9V)S$I)~\u0003&k\u0014)F%RK\u0006\u0005C\u0004i\u0001\t\u0007I\u0011\u0001\u001a\u0002%A{u\nT0O\u00036+u\f\u0015*P!\u0016\u0013F+\u0017\u0005\u0007U\u0002\u0001\u000b\u0011B\u001a\u0002'A{u\nT0O\u00036+u\f\u0015*P!\u0016\u0013F+\u0017\u0011\t\u000f1\u0004!\u0019!C\u0001e\u0005q\u0001kT(M'~\u0003&k\u0014)F%RK\u0006B\u00028\u0001A\u0003%1'A\bQ\u001f>c5k\u0018)S\u001fB+%\u000bV-!\u0011\u001d\u0001\bA1A\u0005\u0002E\fq\u0003R#G\u0003VcEkX*D\u0011\u0016#U\u000bT%O\u000f~ku\nR#\u0016\u0003I\u0004\"a\u001d<\u000f\u0005I!\u0018BA;\u0003\u00039\u00196\r[3ek2LgnZ'pI\u0016L!a\u001e=\u0003\u000bY\u000bG.^3\n\u0005el!aC#ok6,'/\u0019;j_:Daa\u001f\u0001!\u0002\u0013\u0011\u0018\u0001\u0007#F\r\u0006+F\nV0T\u0007\"+E)\u0016'J\u001d\u001e{Vj\u0014#FA!9Q\u0010\u0001b\u0001\n\u0003q\u0018!\u0006#F\r\u0006+F\nV0N\u0013:KU*V'`'\"\u000b%+R\u000b\u0002\u007fB\u0019A\"!\u0001\n\u0007\u0005\rQBA\u0002J]RDq!a\u0002\u0001A\u0003%q0\u0001\fE\u000b\u001a\u000bU\u000b\u0014+`\u001b&s\u0015*T+N?NC\u0015IU#!\u0011!\tY\u0001\u0001b\u0001\n\u0003q\u0018A\u0004#F\r\u0006+F\nV0X\u000b&;\u0005\n\u0016\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003\u0000\u0003=!UIR!V\u0019R{v+R%H\u0011R\u0003\u0003bBA\n\u0001\u0011\u0005\u0013QC\u0001\u000bEVLG\u000e\u001a)p_2\u001cHCAA\f!\ra\u0011\u0011D\u0005\u0004\u00037i!\u0001B+oSRDq!a\b\u0001\t\u0013\t)\"\u0001\tck&dG\rR3gCVdG\u000fU8pY\"9\u00111\u0005\u0001\u0005\n\u0005\u0015\u0012A\u00062vS2$g)Y5s'\u000eDW\rZ;mKJ\u0004vn\u001c7\u0015\r\u0005]\u0011qEA\u001c\u0011!\tI#!\tA\u0002\u0005-\u0012AA5t!\u0011\ti#a\r\u000e\u0005\u0005=\"bAA\u0019o\u0005\u0011\u0011n\\\u0005\u0005\u0003k\tyCA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBA\u001d\u0003C\u0001\raQ\u0001\tM&dWMT1nK\"9\u0011Q\b\u0001\u0005\n\u0005}\u0012AF4fiN\u001b\u0007.\u001a3vY&tw-T8eKZ\u000bG.^3\u0015\u0015\u0005\u0005\u00131LA6\u0003_\n\u0019\b\u0005\u0003\u0002D\u0005UcbAA#i:!\u0011qIA*\u001d\u0011\tI%!\u0015\u000f\t\u0005-\u0013q\n\b\u0004\r\u00065\u0013\"A\u0005\n\u0005\u001dA\u0011BA\u0003\u0007\u0013\t\u0019A!\u0003\u0003\u0002X\u0005e#AD*dQ\u0016$W\u000f\\5oO6{G-\u001a\u0006\u0003k\nA\u0001\"!\u0018\u0002<\u0001\u0007\u0011qL\u0001\ta>|GNT8eKB!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f5\t1\u0001_7m\u0013\u0011\tI'a\u0019\u0003\t9{G-\u001a\u0005\b\u0003[\nY\u00041\u0001D\u0003!\u0001xn\u001c7OC6,\u0007\u0002CA9\u0003w\u0001\r!!\u0011\u0002\u0019\u0011,g-Y;miZ\u000bG.^3\t\u000f\u0005e\u00121\ba\u0001\u0007\"9\u0011q\u000f\u0001\u0005\n\u0005e\u0014aC4fi&sGOV1mk\u0016$2b`A>\u0003{\ny(a!\u0002\u0006\"A\u0011QLA;\u0001\u0004\ty\u0006C\u0004\u0002n\u0005U\u0004\u0019A\"\t\u000f\u0005\u0005\u0015Q\u000fa\u0001\u0007\u0006a\u0001O]8qKJ$\u0018PT1nK\"9\u0011\u0011OA;\u0001\u0004y\bbBA\u001d\u0003k\u0002\ra\u0011\u0005\b\u0003\u0013\u0003A\u0011IAF\u0003E\tG\r\u001a+bg.\u001cV\r^'b]\u0006<WM\u001d\u000b\u0007\u0003/\ti)a&\t\u0011\u0005=\u0015q\u0011a\u0001\u0003#\u000bq!\\1oC\u001e,'\u000fE\u0002\u0013\u0003'K1!!&\u0003\u0005-\u00196\r[3ek2\f'\r\\3\t\u0011\u0005e\u0015q\u0011a\u0001\u00037\u000b!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\ti*a)\u000e\u0005\u0005}%bAAQo\u0005!Q\u000f^5m\u0013\u0011\t)+a(\u0003\u0015A\u0013x\u000e]3si&,7\u000f")
public class FairSchedulableBuilder
implements SchedulableBuilder,
Logging {
    private final Pool rootPool;
    private final String SCHEDULER_ALLOCATION_FILE_PROPERTY;
    private final Option<String> schedulerAllocFile;
    private final String DEFAULT_SCHEDULER_FILE;
    private final String FAIR_SCHEDULER_PROPERTIES;
    private final String DEFAULT_POOL_NAME;
    private final String MINIMUM_SHARES_PROPERTY;
    private final String SCHEDULING_MODE_PROPERTY;
    private final String WEIGHT_PROPERTY;
    private final String POOL_NAME_PROPERTY;
    private final String POOLS_PROPERTY;
    private final Enumeration.Value DEFAULT_SCHEDULING_MODE;
    private final int DEFAULT_MINIMUM_SHARE;
    private final int DEFAULT_WEIGHT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Pool rootPool() {
        return this.rootPool;
    }

    public String SCHEDULER_ALLOCATION_FILE_PROPERTY() {
        return this.SCHEDULER_ALLOCATION_FILE_PROPERTY;
    }

    public Option<String> schedulerAllocFile() {
        return this.schedulerAllocFile;
    }

    public String DEFAULT_SCHEDULER_FILE() {
        return this.DEFAULT_SCHEDULER_FILE;
    }

    public String FAIR_SCHEDULER_PROPERTIES() {
        return this.FAIR_SCHEDULER_PROPERTIES;
    }

    public String DEFAULT_POOL_NAME() {
        return this.DEFAULT_POOL_NAME;
    }

    public String MINIMUM_SHARES_PROPERTY() {
        return this.MINIMUM_SHARES_PROPERTY;
    }

    public String SCHEDULING_MODE_PROPERTY() {
        return this.SCHEDULING_MODE_PROPERTY;
    }

    public String WEIGHT_PROPERTY() {
        return this.WEIGHT_PROPERTY;
    }

    public String POOL_NAME_PROPERTY() {
        return this.POOL_NAME_PROPERTY;
    }

    public String POOLS_PROPERTY() {
        return this.POOLS_PROPERTY;
    }

    public Enumeration.Value DEFAULT_SCHEDULING_MODE() {
        return this.DEFAULT_SCHEDULING_MODE;
    }

    public int DEFAULT_MINIMUM_SHARE() {
        return this.DEFAULT_MINIMUM_SHARE;
    }

    public int DEFAULT_WEIGHT() {
        return this.DEFAULT_WEIGHT;
    }

    @Override
    public void buildPools() {
        None$ fileData = None$.MODULE$;
        try {
            try {
                fileData = (Option)this.schedulerAllocFile().map((Function1 & Serializable & scala.Serializable)f -> {
                    FileInputStream fis = new FileInputStream((String)f);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Creating Fair Scheduler pools from ").append((String)f).toString());
                    return new Some((Object)new Tuple2((Object)fis, f));
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    None$ none$;
                    InputStream is = Utils$.MODULE$.getSparkClassLoader().getResourceAsStream(this.DEFAULT_SCHEDULER_FILE());
                    if (is != null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Creating Fair Scheduler pools from default file: ").append(this.DEFAULT_SCHEDULER_FILE()).toString());
                        none$ = new Some((Object)new Tuple2((Object)is, (Object)this.DEFAULT_SCHEDULER_FILE()));
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(73).append("Fair Scheduler configuration file not found so jobs will be scheduled in ").append(new StringBuilder(59).append("FIFO order. To use fair scheduling, configure pools in ").append(this.DEFAULT_SCHEDULER_FILE()).append(" or ").toString()).append(new StringBuilder(47).append("set ").append(this.SCHEDULER_ALLOCATION_FILE_PROPERTY()).append(" to a file that contains the configuration.").toString()).toString());
                        none$ = None$.MODULE$;
                    }
                    return none$;
                });
                fileData.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FairSchedulableBuilder.$anonfun$buildPools$6(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    String defaultMessage = "Error while building the fair scheduler pools";
                    String message = (String)fileData.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String fileName = (String)tuple2._2();
                        String string = new StringBuilder(6).append(defaultMessage).append(" from ").append(fileName).toString();
                        return string;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultMessage);
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, t);
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            fileData.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                FairSchedulableBuilder.$anonfun$buildPools$10(x0$3);
                return BoxedUnit.UNIT;
            });
        }
        this.buildDefaultPool();
    }

    private void buildDefaultPool() {
        block0: {
            if (this.rootPool().getSchedulableByName(this.DEFAULT_POOL_NAME()) != null) break block0;
            Pool pool = new Pool(this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(pool);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created default pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MINIMUM_SHARE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WEIGHT())})));
        }
    }

    private void buildFairSchedulerPool(InputStream is, String fileName) {
        Elem xml = (Elem)XML$.MODULE$.load(is);
        xml.$bslash$bslash(this.POOLS_PROPERTY()).foreach((Function1 & Serializable & scala.Serializable)poolNode -> {
            FairSchedulableBuilder.$anonfun$buildFairSchedulerPool$1(this, fileName, poolNode);
            return BoxedUnit.UNIT;
        });
    }

    private Enumeration.Value getSchedulingModeValue(Node poolNode, String poolName, Enumeration.Value defaultValue, String fileName) {
        Enumeration.Value value;
        block3: {
            String xmlSchedulingMode = poolNode.$bslash(this.SCHEDULING_MODE_PROPERTY()).text().trim().toUpperCase(Locale.ROOT);
            String warningMessage = new StringBuilder(38).append("Unsupported schedulingMode: ").append(xmlSchedulingMode).append(" found in ").append(new StringBuilder(43).append("Fair Scheduler configuration file: ").append(fileName).append(", using ").toString()).append(new StringBuilder(39).append("the default schedulingMode: ").append(defaultValue).append(" for pool: ").append(poolName).toString()).toString();
            try {
                Enumeration.Value value2 = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                Enumeration.Value value3 = SchedulingMode$.MODULE$.NONE();
                if (value2 == null ? value3 != null : !value2.equals(value3)) {
                    value = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
            catch (NoSuchElementException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
        }
        return value;
    }

    private int getIntValue(Node poolNode, String poolName, String propertyName, int defaultValue, String fileName) {
        int n;
        String data = poolNode.$bslash(propertyName).text().trim();
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(data)).toInt();
        }
        catch (NumberFormatException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while loading fair scheduler configuration from ").append(fileName).append(": ").append(new StringBuilder(44).append(propertyName).append(" is blank or invalid: ").append(data).append(", using the default ").append(propertyName).append(": ").toString()).append(new StringBuilder(11).append(defaultValue).append(" for pool: ").append(poolName).toString()).toString());
            n = defaultValue;
        }
        return n;
    }

    @Override
    public void addTaskSetManager(Schedulable manager, Properties properties) {
        String poolName = properties != null ? properties.getProperty(this.FAIR_SCHEDULER_PROPERTIES(), this.DEFAULT_POOL_NAME()) : this.DEFAULT_POOL_NAME();
        Schedulable parentPool = this.rootPool().getSchedulableByName(poolName);
        if (parentPool == null) {
            parentPool = new Pool(poolName, this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(parentPool);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(142).append("A job was submitted with scheduler pool ").append(poolName).append(", which has not been ").append("configured. This can happen when the file that pools are read from isn't set, or ").append(new StringBuilder(55).append("when that file doesn't contain ").append(poolName).append(". Created ").append(poolName).append(" with default ").toString()).append(new StringBuilder(33).append("configuration (schedulingMode: ").append(this.DEFAULT_SCHEDULING_MODE()).append(", ").toString()).append(new StringBuilder(21).append("minShare: ").append(this.DEFAULT_MINIMUM_SHARE()).append(", weight: ").append(this.DEFAULT_WEIGHT()).append(")").toString()).toString());
        }
        parentPool.addSchedulable(manager);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Added task set ").append(manager.name()).append(" tasks to pool ").append(poolName).toString());
    }

    public static final /* synthetic */ void $anonfun$buildPools$6(FairSchedulableBuilder $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        String fileName = (String)tuple2._2();
        $this.buildFairSchedulerPool(is, fileName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildPools$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        is.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildFairSchedulerPool$1(FairSchedulableBuilder $this, String fileName$1, Node poolNode) {
        String poolName = poolNode.$bslash($this.POOL_NAME_PROPERTY()).text();
        Enumeration.Value schedulingMode = $this.getSchedulingModeValue(poolNode, poolName, $this.DEFAULT_SCHEDULING_MODE(), fileName$1);
        int minShare = $this.getIntValue(poolNode, poolName, $this.MINIMUM_SHARES_PROPERTY(), $this.DEFAULT_MINIMUM_SHARE(), fileName$1);
        int weight = $this.getIntValue(poolNode, poolName, $this.WEIGHT_PROPERTY(), $this.DEFAULT_WEIGHT(), fileName$1);
        $this.rootPool().addSchedulable(new Pool(poolName, schedulingMode, minShare, weight));
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{poolName, schedulingMode, BoxesRunTime.boxToInteger((int)minShare), BoxesRunTime.boxToInteger((int)weight)})));
    }

    public FairSchedulableBuilder(Pool rootPool, SparkConf conf) {
        this.rootPool = rootPool;
        Logging.$init$(this);
        this.SCHEDULER_ALLOCATION_FILE_PROPERTY = "spark.scheduler.allocation.file";
        this.schedulerAllocFile = conf.getOption(this.SCHEDULER_ALLOCATION_FILE_PROPERTY());
        this.DEFAULT_SCHEDULER_FILE = "fairscheduler.xml";
        this.FAIR_SCHEDULER_PROPERTIES = "spark.scheduler.pool";
        this.DEFAULT_POOL_NAME = "default";
        this.MINIMUM_SHARES_PROPERTY = "minShare";
        this.SCHEDULING_MODE_PROPERTY = "schedulingMode";
        this.WEIGHT_PROPERTY = "weight";
        this.POOL_NAME_PROPERTY = "@name";
        this.POOLS_PROPERTY = "pool";
        this.DEFAULT_SCHEDULING_MODE = SchedulingMode$.MODULE$.FIFO();
        this.DEFAULT_MINIMUM_SHARE = 0;
        this.DEFAULT_WEIGHT = 1;
    }
}

