/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.autopilot.v1.assistant.DialogueFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Dialogue
extends Resource {
    private static final long serialVersionUID = 58246367939830L;
    private final String accountSid;
    private final String assistantSid;
    private final String sid;
    private final Map<String, Object> data;
    private final URI url;

    public static DialogueFetcher fetcher(String pathAssistantSid, String pathSid) {
        return new DialogueFetcher(pathAssistantSid, pathSid);
    }

    public static Dialogue fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Dialogue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Dialogue fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Dialogue.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Dialogue(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="assistant_sid") String assistantSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.assistantSid = assistantSid;
        this.sid = sid;
        this.data = data;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getAssistantSid() {
        return this.assistantSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dialogue other = (Dialogue)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.assistantSid, other.assistantSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.data, other.data) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.assistantSid, this.sid, this.data, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("assistantSid", this.assistantSid).add("sid", this.sid).add("data", this.data).add("url", this.url).toString();
    }
}

