/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.KeyDeleter;
import com.twilio.rest.api.v2010.account.KeyFetcher;
import com.twilio.rest.api.v2010.account.KeyReader;
import com.twilio.rest.api.v2010.account.KeyUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Key
extends Resource {
    private static final long serialVersionUID = 96350302686036L;
    private final String sid;
    private final String friendlyName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static KeyFetcher fetcher(String pathAccountSid, String pathSid) {
        return new KeyFetcher(pathAccountSid, pathSid);
    }

    public static KeyFetcher fetcher(String pathSid) {
        return new KeyFetcher(pathSid);
    }

    public static KeyUpdater updater(String pathAccountSid, String pathSid) {
        return new KeyUpdater(pathAccountSid, pathSid);
    }

    public static KeyUpdater updater(String pathSid) {
        return new KeyUpdater(pathSid);
    }

    public static KeyDeleter deleter(String pathAccountSid, String pathSid) {
        return new KeyDeleter(pathAccountSid, pathSid);
    }

    public static KeyDeleter deleter(String pathSid) {
        return new KeyDeleter(pathSid);
    }

    public static KeyReader reader(String pathAccountSid) {
        return new KeyReader(pathAccountSid);
    }

    public static KeyReader reader() {
        return new KeyReader();
    }

    public static Key fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Key.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Key fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Key.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Key(@JsonProperty(value="sid") String sid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.friendlyName = friendlyName;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key other = (Key)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.friendlyName, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("friendlyName", this.friendlyName).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).toString();
    }
}

