/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.moneyandcurrency.joda;

import java.util.Properties;
import org.hibernate.SessionFactory;
import org.hibernate.usertype.ParameterizedType;
import org.jadira.usertype.moneyandcurrency.joda.util.CurrencyUnitConfigured;
import org.jadira.usertype.spi.shared.AbstractSingleColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;
import org.jadira.usertype.spi.utils.lang.ConcurrentHashMapBackedProperties;
import org.joda.money.CurrencyUnit;

public abstract class AbstractSingleColumnMoneyUserType<T, J, C extends ColumnMapper<T, J>>
extends AbstractSingleColumnUserType<T, J, C>
implements ParameterizedType,
IntegratorConfiguredType {
    private static final long serialVersionUID = 8244061728586173961L;
    private Properties parameterValues;
    private CurrencyUnit currencyUnit;

    public void setParameterValues(Properties parameters) {
        this.parameterValues = new ConcurrentHashMapBackedProperties(parameters);
    }

    protected Properties getParameterValues() {
        return this.parameterValues;
    }

    public void applyConfiguration(SessionFactory sessionFactory) {
        CurrencyUnitConfigured columnMapper = (CurrencyUnitConfigured)this.getColumnMapper();
        if (this.currencyUnit == null) {
            String currencyString = null;
            if (this.parameterValues != null) {
                currencyString = this.parameterValues.getProperty("currencyCode");
            }
            if (currencyString == null) {
                currencyString = ConfigurationHelper.getProperty((String)"currencyCode");
            }
            if (currencyString != null) {
                this.currencyUnit = CurrencyUnit.of((String)currencyString);
            } else {
                throw new IllegalStateException(((Object)((Object)this)).getClass().getSimpleName() + " requires currencyCode to be defined as a parameter, or the jadira.usertype.currencyCode Hibernate property to be defined");
            }
        }
        columnMapper.setCurrencyUnit(this.currencyUnit);
    }
}

