/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.sql.Time;
import java.time.Instant;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import org.jadira.usertype.spi.shared.AbstractTimeColumnMapper;
import org.jadira.usertype.spi.shared.JavaZoneConfigured;

public class TimeColumnOffsetTimeMapper
extends AbstractTimeColumnMapper<OffsetTime>
implements JavaZoneConfigured<ZoneOffset> {
    private static final long serialVersionUID = 6734385103313158326L;
    public static final DateTimeFormatter LOCAL_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("HH:mm:ss").toFormatter();
    private ZoneOffset javaZone = null;

    public TimeColumnOffsetTimeMapper() {
    }

    public TimeColumnOffsetTimeMapper(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    public OffsetTime fromNonNullString(String s) {
        return OffsetTime.parse(s);
    }

    public OffsetTime fromNonNullValue(Time value) {
        return Instant.ofEpochMilli(value.getTime()).atOffset(this.javaZone).toOffsetTime();
    }

    public String toNonNullString(OffsetTime value) {
        return value.toString();
    }

    public Time toNonNullValue(OffsetTime value) {
        return Time.valueOf(LOCAL_TIME_FORMATTER.format(value));
    }

    public void setJavaZone(ZoneOffset javaZone) {
        this.javaZone = javaZone;
    }

    public ZoneOffset parseJavaZone(String zoneString) {
        return ZoneOffset.of(zoneString);
    }
}

