/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.Identity;
import com.twilio.twiml.voice.Parameter;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Client
extends TwiML {
    private final URI url;
    private final HttpMethod method;
    private final List<Event> statusCallbackEvent;
    private final URI statusCallback;
    private final HttpMethod statusCallbackMethod;
    private final String identity;

    private Client() {
        this(new Builder());
    }

    private Client(Builder b) {
        super("Client", b);
        this.url = b.url;
        this.method = b.method;
        this.statusCallbackEvent = b.statusCallbackEvent;
        this.statusCallback = b.statusCallback;
        this.statusCallbackMethod = b.statusCallbackMethod;
        this.identity = b.identity;
    }

    @Override
    protected String getElementBody() {
        return this.getIdentity() == null ? null : this.getIdentity();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getUrl() != null) {
            attrs.put("url", this.getUrl().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getStatusCallbackEvents() != null) {
            attrs.put("statusCallbackEvent", this.getStatusCallbackEventsAsString());
        }
        if (this.getStatusCallback() != null) {
            attrs.put("statusCallback", this.getStatusCallback().toString());
        }
        if (this.getStatusCallbackMethod() != null) {
            attrs.put("statusCallbackMethod", this.getStatusCallbackMethod().toString());
        }
        return attrs;
    }

    public URI getUrl() {
        return this.url;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<Event> getStatusCallbackEvents() {
        return this.statusCallbackEvent;
    }

    protected String getStatusCallbackEventsAsString() {
        StringBuilder sb = new StringBuilder();
        Iterator<Event> iter = this.getStatusCallbackEvents().iterator();
        while (iter.hasNext()) {
            sb.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public URI getStatusCallback() {
        return this.statusCallback;
    }

    public HttpMethod getStatusCallbackMethod() {
        return this.statusCallbackMethod;
    }

    public String getIdentity() {
        return this.identity;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI url;
        private HttpMethod method;
        private List<Event> statusCallbackEvent;
        private URI statusCallback;
        private HttpMethod statusCallbackMethod;
        private String identity;

        public Builder(String identity) {
            this.identity = identity;
        }

        public Builder() {
        }

        public Builder url(URI url) {
            this.url = url;
            return this;
        }

        public Builder url(String url) {
            this.url = Promoter.uriFromString(url);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder statusCallbackEvents(List<Event> statusCallbackEvent) {
            this.statusCallbackEvent = statusCallbackEvent;
            return this;
        }

        public Builder statusCallbackEvents(Event statusCallbackEvent) {
            this.statusCallbackEvent = Promoter.listOfOne(statusCallbackEvent);
            return this;
        }

        public Builder statusCallback(URI statusCallback) {
            this.statusCallback = statusCallback;
            return this;
        }

        public Builder statusCallback(String statusCallback) {
            this.statusCallback = Promoter.uriFromString(statusCallback);
            return this;
        }

        public Builder statusCallbackMethod(HttpMethod statusCallbackMethod) {
            this.statusCallbackMethod = statusCallbackMethod;
            return this;
        }

        public Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public Builder identity(Identity identity) {
            this.children.add(identity);
            return this;
        }

        public Builder parameter(Parameter parameter) {
            this.children.add(parameter);
            return this;
        }

        public Client build() {
            return new Client(this);
        }
    }

    public static enum Event {
        INITIATED("initiated"),
        RINGING("ringing"),
        ANSWERED("answered"),
        COMPLETED("completed");

        private final String value;

        private Event(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

