/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.video.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.video.v1.CompositionHook;
import org.joda.time.DateTime;

public class CompositionHookReader
extends Reader<CompositionHook> {
    private Boolean enabled;
    private DateTime dateCreatedAfter;
    private DateTime dateCreatedBefore;

    public CompositionHookReader setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public CompositionHookReader setDateCreatedAfter(DateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    public CompositionHookReader setDateCreatedBefore(DateTime dateCreatedBefore) {
        this.dateCreatedBefore = dateCreatedBefore;
        return this;
    }

    @Override
    public ResourceSet<CompositionHook> read(TwilioRestClient client) {
        return new ResourceSet<CompositionHook>(this, client, this.firstPage(client));
    }

    @Override
    public Page<CompositionHook> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.VIDEO.toString(), "/v1/CompositionHooks", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CompositionHook> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CompositionHook> nextPage(Page<CompositionHook> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<CompositionHook> previousPage(Page<CompositionHook> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.VIDEO.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<CompositionHook> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("CompositionHook read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("composition_hooks", response.getContent(), CompositionHook.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.enabled != null) {
            request.addQueryParam("Enabled", this.enabled.toString());
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toString());
        }
        if (this.dateCreatedBefore != null) {
            request.addQueryParam("DateCreatedBefore", this.dateCreatedBefore.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

