/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace.workflow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.workflow.WorkflowRealTimeStatisticsFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class WorkflowRealTimeStatistics
extends Resource {
    private static final long serialVersionUID = 202087989924L;
    private final String accountSid;
    private final Integer longestTaskWaitingAge;
    private final Map<String, Object> tasksByPriority;
    private final Map<String, Object> tasksByStatus;
    private final Integer totalTasks;
    private final String workflowSid;
    private final String workspaceSid;
    private final URI url;

    public static WorkflowRealTimeStatisticsFetcher fetcher(String pathWorkspaceSid, String pathWorkflowSid) {
        return new WorkflowRealTimeStatisticsFetcher(pathWorkspaceSid, pathWorkflowSid);
    }

    public static WorkflowRealTimeStatistics fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkflowRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static WorkflowRealTimeStatistics fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, WorkflowRealTimeStatistics.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private WorkflowRealTimeStatistics(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="longest_task_waiting_age") Integer longestTaskWaitingAge, @JsonProperty(value="tasks_by_priority") Map<String, Object> tasksByPriority, @JsonProperty(value="tasks_by_status") Map<String, Object> tasksByStatus, @JsonProperty(value="total_tasks") Integer totalTasks, @JsonProperty(value="workflow_sid") String workflowSid, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.longestTaskWaitingAge = longestTaskWaitingAge;
        this.tasksByPriority = tasksByPriority;
        this.tasksByStatus = tasksByStatus;
        this.totalTasks = totalTasks;
        this.workflowSid = workflowSid;
        this.workspaceSid = workspaceSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getLongestTaskWaitingAge() {
        return this.longestTaskWaitingAge;
    }

    public final Map<String, Object> getTasksByPriority() {
        return this.tasksByPriority;
    }

    public final Map<String, Object> getTasksByStatus() {
        return this.tasksByStatus;
    }

    public final Integer getTotalTasks() {
        return this.totalTasks;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkflowRealTimeStatistics other = (WorkflowRealTimeStatistics)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.longestTaskWaitingAge, other.longestTaskWaitingAge) && Objects.equals(this.tasksByPriority, other.tasksByPriority) && Objects.equals(this.tasksByStatus, other.tasksByStatus) && Objects.equals(this.totalTasks, other.totalTasks) && Objects.equals(this.workflowSid, other.workflowSid) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.longestTaskWaitingAge, this.tasksByPriority, this.tasksByStatus, this.totalTasks, this.workflowSid, this.workspaceSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("longestTaskWaitingAge", this.longestTaskWaitingAge).add("tasksByPriority", this.tasksByPriority).add("tasksByStatus", this.tasksByStatus).add("totalTasks", this.totalTasks).add("workflowSid", this.workflowSid).add("workspaceSid", this.workspaceSid).add("url", this.url).toString();
    }
}

