/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.taskrouter.v1.workspace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.taskrouter.v1.workspace.TaskCreator;
import com.twilio.rest.taskrouter.v1.workspace.TaskDeleter;
import com.twilio.rest.taskrouter.v1.workspace.TaskFetcher;
import com.twilio.rest.taskrouter.v1.workspace.TaskReader;
import com.twilio.rest.taskrouter.v1.workspace.TaskUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Task
extends Resource {
    private static final long serialVersionUID = 85038586124308L;
    private final String accountSid;
    private final Integer age;
    private final Status assignmentStatus;
    private final String attributes;
    private final String addons;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final Integer priority;
    private final String reason;
    private final String sid;
    private final String taskQueueSid;
    private final String taskQueueFriendlyName;
    private final String taskChannelSid;
    private final String taskChannelUniqueName;
    private final Integer timeout;
    private final String workflowSid;
    private final String workflowFriendlyName;
    private final String workspaceSid;
    private final URI url;
    private final Map<String, String> links;

    public static TaskFetcher fetcher(String pathWorkspaceSid, String pathSid) {
        return new TaskFetcher(pathWorkspaceSid, pathSid);
    }

    public static TaskUpdater updater(String pathWorkspaceSid, String pathSid) {
        return new TaskUpdater(pathWorkspaceSid, pathSid);
    }

    public static TaskDeleter deleter(String pathWorkspaceSid, String pathSid) {
        return new TaskDeleter(pathWorkspaceSid, pathSid);
    }

    public static TaskReader reader(String pathWorkspaceSid) {
        return new TaskReader(pathWorkspaceSid);
    }

    public static TaskCreator creator(String pathWorkspaceSid) {
        return new TaskCreator(pathWorkspaceSid);
    }

    public static Task fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Task fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Task.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Task(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="age") Integer age, @JsonProperty(value="assignment_status") Status assignmentStatus, @JsonProperty(value="attributes") String attributes, @JsonProperty(value="addons") String addons, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="priority") Integer priority, @JsonProperty(value="reason") String reason, @JsonProperty(value="sid") String sid, @JsonProperty(value="task_queue_sid") String taskQueueSid, @JsonProperty(value="task_queue_friendly_name") String taskQueueFriendlyName, @JsonProperty(value="task_channel_sid") String taskChannelSid, @JsonProperty(value="task_channel_unique_name") String taskChannelUniqueName, @JsonProperty(value="timeout") Integer timeout, @JsonProperty(value="workflow_sid") String workflowSid, @JsonProperty(value="workflow_friendly_name") String workflowFriendlyName, @JsonProperty(value="workspace_sid") String workspaceSid, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.accountSid = accountSid;
        this.age = age;
        this.assignmentStatus = assignmentStatus;
        this.attributes = attributes;
        this.addons = addons;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.priority = priority;
        this.reason = reason;
        this.sid = sid;
        this.taskQueueSid = taskQueueSid;
        this.taskQueueFriendlyName = taskQueueFriendlyName;
        this.taskChannelSid = taskChannelSid;
        this.taskChannelUniqueName = taskChannelUniqueName;
        this.timeout = timeout;
        this.workflowSid = workflowSid;
        this.workflowFriendlyName = workflowFriendlyName;
        this.workspaceSid = workspaceSid;
        this.url = url;
        this.links = links;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Integer getAge() {
        return this.age;
    }

    public final Status getAssignmentStatus() {
        return this.assignmentStatus;
    }

    public final String getAttributes() {
        return this.attributes;
    }

    public final String getAddons() {
        return this.addons;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final Integer getPriority() {
        return this.priority;
    }

    public final String getReason() {
        return this.reason;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getTaskQueueSid() {
        return this.taskQueueSid;
    }

    public final String getTaskQueueFriendlyName() {
        return this.taskQueueFriendlyName;
    }

    public final String getTaskChannelSid() {
        return this.taskChannelSid;
    }

    public final String getTaskChannelUniqueName() {
        return this.taskChannelUniqueName;
    }

    public final Integer getTimeout() {
        return this.timeout;
    }

    public final String getWorkflowSid() {
        return this.workflowSid;
    }

    public final String getWorkflowFriendlyName() {
        return this.workflowFriendlyName;
    }

    public final String getWorkspaceSid() {
        return this.workspaceSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Task other = (Task)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.age, other.age) && Objects.equals((Object)this.assignmentStatus, (Object)other.assignmentStatus) && Objects.equals(this.attributes, other.attributes) && Objects.equals(this.addons, other.addons) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.priority, other.priority) && Objects.equals(this.reason, other.reason) && Objects.equals(this.sid, other.sid) && Objects.equals(this.taskQueueSid, other.taskQueueSid) && Objects.equals(this.taskQueueFriendlyName, other.taskQueueFriendlyName) && Objects.equals(this.taskChannelSid, other.taskChannelSid) && Objects.equals(this.taskChannelUniqueName, other.taskChannelUniqueName) && Objects.equals(this.timeout, other.timeout) && Objects.equals(this.workflowSid, other.workflowSid) && Objects.equals(this.workflowFriendlyName, other.workflowFriendlyName) && Objects.equals(this.workspaceSid, other.workspaceSid) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.age, this.assignmentStatus, this.attributes, this.addons, this.dateCreated, this.dateUpdated, this.priority, this.reason, this.sid, this.taskQueueSid, this.taskQueueFriendlyName, this.taskChannelSid, this.taskChannelUniqueName, this.timeout, this.workflowSid, this.workflowFriendlyName, this.workspaceSid, this.url, this.links});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("age", this.age).add("assignmentStatus", (Object)this.assignmentStatus).add("attributes", this.attributes).add("addons", this.addons).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("priority", this.priority).add("reason", this.reason).add("sid", this.sid).add("taskQueueSid", this.taskQueueSid).add("taskQueueFriendlyName", this.taskQueueFriendlyName).add("taskChannelSid", this.taskChannelSid).add("taskChannelUniqueName", this.taskChannelUniqueName).add("timeout", this.timeout).add("workflowSid", this.workflowSid).add("workflowFriendlyName", this.workflowFriendlyName).add("workspaceSid", this.workspaceSid).add("url", this.url).add("links", this.links).toString();
    }

    public static enum Status {
        PENDING("pending"),
        RESERVED("reserved"),
        ASSIGNED("assigned"),
        CANCELED("canceled"),
        COMPLETED("completed"),
        WRAPPING("wrapping");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

