/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.studio.v1.flow.engagement.step;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.studio.v1.flow.engagement.step.StepContextFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StepContext
extends Resource {
    private static final long serialVersionUID = 27085286936981L;
    private final String accountSid;
    private final Map<String, Object> context;
    private final String engagementSid;
    private final String flowSid;
    private final String stepSid;
    private final URI url;

    public static StepContextFetcher fetcher(String pathFlowSid, String pathEngagementSid, String pathStepSid) {
        return new StepContextFetcher(pathFlowSid, pathEngagementSid, pathStepSid);
    }

    public static StepContext fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StepContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static StepContext fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, StepContext.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private StepContext(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="context") Map<String, Object> context, @JsonProperty(value="engagement_sid") String engagementSid, @JsonProperty(value="flow_sid") String flowSid, @JsonProperty(value="step_sid") String stepSid, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.context = context;
        this.engagementSid = engagementSid;
        this.flowSid = flowSid;
        this.stepSid = stepSid;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final Map<String, Object> getContext() {
        return this.context;
    }

    public final String getEngagementSid() {
        return this.engagementSid;
    }

    public final String getFlowSid() {
        return this.flowSid;
    }

    public final String getStepSid() {
        return this.stepSid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StepContext other = (StepContext)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.context, other.context) && Objects.equals(this.engagementSid, other.engagementSid) && Objects.equals(this.flowSid, other.flowSid) && Objects.equals(this.stepSid, other.stepSid) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.context, this.engagementSid, this.flowSid, this.stepSid, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("context", this.context).add("engagementSid", this.engagementSid).add("flowSid", this.flowSid).add("stepSid", this.stepSid).add("url", this.url).toString();
    }
}

