/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.wireless;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.wireless.RatePlan;
import java.util.List;

public class RatePlanCreator
extends Creator<RatePlan> {
    private String uniqueName;
    private String friendlyName;
    private Boolean dataEnabled;
    private Integer dataLimit;
    private String dataMetering;
    private Boolean messagingEnabled;
    private Boolean voiceEnabled;
    private Boolean commandsEnabled;
    private Boolean nationalRoamingEnabled;
    private List<String> internationalRoaming;

    public RatePlanCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public RatePlanCreator setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
        return this;
    }

    public RatePlanCreator setDataEnabled(Boolean dataEnabled) {
        this.dataEnabled = dataEnabled;
        return this;
    }

    public RatePlanCreator setDataLimit(Integer dataLimit) {
        this.dataLimit = dataLimit;
        return this;
    }

    public RatePlanCreator setDataMetering(String dataMetering) {
        this.dataMetering = dataMetering;
        return this;
    }

    public RatePlanCreator setMessagingEnabled(Boolean messagingEnabled) {
        this.messagingEnabled = messagingEnabled;
        return this;
    }

    public RatePlanCreator setVoiceEnabled(Boolean voiceEnabled) {
        this.voiceEnabled = voiceEnabled;
        return this;
    }

    public RatePlanCreator setCommandsEnabled(Boolean commandsEnabled) {
        this.commandsEnabled = commandsEnabled;
        return this;
    }

    public RatePlanCreator setNationalRoamingEnabled(Boolean nationalRoamingEnabled) {
        this.nationalRoamingEnabled = nationalRoamingEnabled;
        return this;
    }

    public RatePlanCreator setInternationalRoaming(List<String> internationalRoaming) {
        this.internationalRoaming = internationalRoaming;
        return this;
    }

    public RatePlanCreator setInternationalRoaming(String internationalRoaming) {
        return this.setInternationalRoaming(Promoter.listOfOne(internationalRoaming));
    }

    @Override
    public RatePlan create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/wireless/RatePlans", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("RatePlan creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return RatePlan.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.dataEnabled != null) {
            request.addPostParam("DataEnabled", this.dataEnabled.toString());
        }
        if (this.dataLimit != null) {
            request.addPostParam("DataLimit", this.dataLimit.toString());
        }
        if (this.dataMetering != null) {
            request.addPostParam("DataMetering", this.dataMetering);
        }
        if (this.messagingEnabled != null) {
            request.addPostParam("MessagingEnabled", this.messagingEnabled.toString());
        }
        if (this.voiceEnabled != null) {
            request.addPostParam("VoiceEnabled", this.voiceEnabled.toString());
        }
        if (this.commandsEnabled != null) {
            request.addPostParam("CommandsEnabled", this.commandsEnabled.toString());
        }
        if (this.nationalRoamingEnabled != null) {
            request.addPostParam("NationalRoamingEnabled", this.nationalRoamingEnabled.toString());
        }
        if (this.internationalRoaming != null) {
            for (String prop : this.internationalRoaming) {
                request.addPostParam("InternationalRoaming", prop);
            }
        }
    }
}

