/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.understand.assistant;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.understand.assistant.Query;

public class QueryReader
extends Reader<Query> {
    private final String pathAssistantSid;
    private String language;
    private String modelBuild;
    private String status;

    public QueryReader(String pathAssistantSid) {
        this.pathAssistantSid = pathAssistantSid;
    }

    public QueryReader setLanguage(String language) {
        this.language = language;
        return this;
    }

    public QueryReader setModelBuild(String modelBuild) {
        this.modelBuild = modelBuild;
        return this;
    }

    public QueryReader setStatus(String status) {
        this.status = status;
        return this;
    }

    @Override
    public ResourceSet<Query> read(TwilioRestClient client) {
        return new ResourceSet<Query>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Query> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/understand/Assistants/" + this.pathAssistantSid + "/Queries", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Query> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Query> nextPage(Page<Query> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Query> previousPage(Page<Query> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.PREVIEW.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Query> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Query read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("queries", response.getContent(), Query.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.language != null) {
            request.addQueryParam("Language", this.language);
        }
        if (this.modelBuild != null) {
            request.addQueryParam("ModelBuild", this.modelBuild.toString());
        }
        if (this.status != null) {
            request.addQueryParam("Status", this.status);
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

