/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.sync.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.sync.service.SyncList;

public class SyncListCreator
extends Creator<SyncList> {
    private final String pathServiceSid;
    private String uniqueName;

    public SyncListCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public SyncListCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @Override
    public SyncList create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Sync/Services/" + this.pathServiceSid + "/Lists", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("SyncList creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return SyncList.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

