/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.hostedNumbers;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.hostedNumbers.AuthorizationDocument;
import java.util.List;

public class AuthorizationDocumentCreator
extends Creator<AuthorizationDocument> {
    private final List<String> hostedNumberOrderSids;
    private final String addressSid;
    private final String email;
    private final String contactTitle;
    private final String contactPhoneNumber;
    private List<String> ccEmails;

    public AuthorizationDocumentCreator(List<String> hostedNumberOrderSids, String addressSid, String email, String contactTitle, String contactPhoneNumber) {
        this.hostedNumberOrderSids = hostedNumberOrderSids;
        this.addressSid = addressSid;
        this.email = email;
        this.contactTitle = contactTitle;
        this.contactPhoneNumber = contactPhoneNumber;
    }

    public AuthorizationDocumentCreator setCcEmails(List<String> ccEmails) {
        this.ccEmails = ccEmails;
        return this;
    }

    public AuthorizationDocumentCreator setCcEmails(String ccEmails) {
        return this.setCcEmails(Promoter.listOfOne(ccEmails));
    }

    @Override
    public AuthorizationDocument create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/HostedNumbers/AuthorizationDocuments", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("AuthorizationDocument creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return AuthorizationDocument.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.hostedNumberOrderSids != null) {
            for (String prop : this.hostedNumberOrderSids) {
                request.addPostParam("HostedNumberOrderSids", prop);
            }
        }
        if (this.addressSid != null) {
            request.addPostParam("AddressSid", this.addressSid);
        }
        if (this.email != null) {
            request.addPostParam("Email", this.email);
        }
        if (this.contactTitle != null) {
            request.addPostParam("ContactTitle", this.contactTitle);
        }
        if (this.contactPhoneNumber != null) {
            request.addPostParam("ContactPhoneNumber", this.contactPhoneNumber);
        }
        if (this.ccEmails != null) {
            for (String prop : this.ccEmails) {
                request.addPostParam("CcEmails", prop);
            }
        }
    }
}

