/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.deployedDevices.fleet;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.deployedDevices.fleet.DeploymentCreator;
import com.twilio.rest.preview.deployedDevices.fleet.DeploymentDeleter;
import com.twilio.rest.preview.deployedDevices.fleet.DeploymentFetcher;
import com.twilio.rest.preview.deployedDevices.fleet.DeploymentReader;
import com.twilio.rest.preview.deployedDevices.fleet.DeploymentUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Deployment
extends Resource {
    private static final long serialVersionUID = 277943167449675L;
    private final String sid;
    private final URI url;
    private final String friendlyName;
    private final String fleetSid;
    private final String accountSid;
    private final String syncServiceSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;

    public static DeploymentFetcher fetcher(String pathFleetSid, String pathSid) {
        return new DeploymentFetcher(pathFleetSid, pathSid);
    }

    public static DeploymentDeleter deleter(String pathFleetSid, String pathSid) {
        return new DeploymentDeleter(pathFleetSid, pathSid);
    }

    public static DeploymentCreator creator(String pathFleetSid) {
        return new DeploymentCreator(pathFleetSid);
    }

    public static DeploymentReader reader(String pathFleetSid) {
        return new DeploymentReader(pathFleetSid);
    }

    public static DeploymentUpdater updater(String pathFleetSid, String pathSid) {
        return new DeploymentUpdater(pathFleetSid, pathSid);
    }

    public static Deployment fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Deployment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Deployment fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Deployment.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Deployment(@JsonProperty(value="sid") String sid, @JsonProperty(value="url") URI url, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sync_service_sid") String syncServiceSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated) {
        this.sid = sid;
        this.url = url;
        this.friendlyName = friendlyName;
        this.fleetSid = fleetSid;
        this.accountSid = accountSid;
        this.syncServiceSid = syncServiceSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
    }

    public final String getSid() {
        return this.sid;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSyncServiceSid() {
        return this.syncServiceSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Deployment other = (Deployment)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.url, other.url) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.syncServiceSid, other.syncServiceSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.url, this.friendlyName, this.fleetSid, this.accountSid, this.syncServiceSid, this.dateCreated, this.dateUpdated);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("sid", this.sid).add("url", this.url).add("friendlyName", this.friendlyName).add("fleetSid", this.fleetSid).add("accountSid", this.accountSid).add("syncServiceSid", this.syncServiceSid).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).toString();
    }
}

