/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.messaging.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.messaging.v1.Service;
import java.net.URI;

public class ServiceCreator
extends Creator<Service> {
    private final String friendlyName;
    private URI inboundRequestUrl;
    private HttpMethod inboundMethod;
    private URI fallbackUrl;
    private HttpMethod fallbackMethod;
    private URI statusCallback;
    private Boolean stickySender;
    private Boolean mmsConverter;
    private Boolean smartEncoding;
    private Service.ScanMessageContent scanMessageContent;
    private Boolean fallbackToLongCode;
    private Boolean areaCodeGeomatch;
    private Integer validityPeriod;
    private Boolean synchronousValidation;

    public ServiceCreator(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    public ServiceCreator setInboundRequestUrl(URI inboundRequestUrl) {
        this.inboundRequestUrl = inboundRequestUrl;
        return this;
    }

    public ServiceCreator setInboundRequestUrl(String inboundRequestUrl) {
        return this.setInboundRequestUrl(Promoter.uriFromString(inboundRequestUrl));
    }

    public ServiceCreator setInboundMethod(HttpMethod inboundMethod) {
        this.inboundMethod = inboundMethod;
        return this;
    }

    public ServiceCreator setFallbackUrl(URI fallbackUrl) {
        this.fallbackUrl = fallbackUrl;
        return this;
    }

    public ServiceCreator setFallbackUrl(String fallbackUrl) {
        return this.setFallbackUrl(Promoter.uriFromString(fallbackUrl));
    }

    public ServiceCreator setFallbackMethod(HttpMethod fallbackMethod) {
        this.fallbackMethod = fallbackMethod;
        return this;
    }

    public ServiceCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public ServiceCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public ServiceCreator setStickySender(Boolean stickySender) {
        this.stickySender = stickySender;
        return this;
    }

    public ServiceCreator setMmsConverter(Boolean mmsConverter) {
        this.mmsConverter = mmsConverter;
        return this;
    }

    public ServiceCreator setSmartEncoding(Boolean smartEncoding) {
        this.smartEncoding = smartEncoding;
        return this;
    }

    public ServiceCreator setScanMessageContent(Service.ScanMessageContent scanMessageContent) {
        this.scanMessageContent = scanMessageContent;
        return this;
    }

    public ServiceCreator setFallbackToLongCode(Boolean fallbackToLongCode) {
        this.fallbackToLongCode = fallbackToLongCode;
        return this;
    }

    public ServiceCreator setAreaCodeGeomatch(Boolean areaCodeGeomatch) {
        this.areaCodeGeomatch = areaCodeGeomatch;
        return this;
    }

    public ServiceCreator setValidityPeriod(Integer validityPeriod) {
        this.validityPeriod = validityPeriod;
        return this;
    }

    public ServiceCreator setSynchronousValidation(Boolean synchronousValidation) {
        this.synchronousValidation = synchronousValidation;
        return this;
    }

    @Override
    public Service create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.MESSAGING.toString(), "/v1/Services", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.friendlyName != null) {
            request.addPostParam("FriendlyName", this.friendlyName);
        }
        if (this.inboundRequestUrl != null) {
            request.addPostParam("InboundRequestUrl", this.inboundRequestUrl.toString());
        }
        if (this.inboundMethod != null) {
            request.addPostParam("InboundMethod", this.inboundMethod.toString());
        }
        if (this.fallbackUrl != null) {
            request.addPostParam("FallbackUrl", this.fallbackUrl.toString());
        }
        if (this.fallbackMethod != null) {
            request.addPostParam("FallbackMethod", this.fallbackMethod.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.stickySender != null) {
            request.addPostParam("StickySender", this.stickySender.toString());
        }
        if (this.mmsConverter != null) {
            request.addPostParam("MmsConverter", this.mmsConverter.toString());
        }
        if (this.smartEncoding != null) {
            request.addPostParam("SmartEncoding", this.smartEncoding.toString());
        }
        if (this.scanMessageContent != null) {
            request.addPostParam("ScanMessageContent", this.scanMessageContent.toString());
        }
        if (this.fallbackToLongCode != null) {
            request.addPostParam("FallbackToLongCode", this.fallbackToLongCode.toString());
        }
        if (this.areaCodeGeomatch != null) {
            request.addPostParam("AreaCodeGeomatch", this.areaCodeGeomatch.toString());
        }
        if (this.validityPeriod != null) {
            request.addPostParam("ValidityPeriod", this.validityPeriod.toString());
        }
        if (this.synchronousValidation != null) {
            request.addPostParam("SynchronousValidation", this.synchronousValidation.toString());
        }
    }
}

