/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1.fax;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.fax.v1.fax.FaxMedia;

public class FaxMediaFetcher
extends Fetcher<FaxMedia> {
    private final String pathFaxSid;
    private final String pathSid;

    public FaxMediaFetcher(String pathFaxSid, String pathSid) {
        this.pathFaxSid = pathFaxSid;
        this.pathSid = pathSid;
    }

    @Override
    public FaxMedia fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.FAX.toString(), "/v1/Faxes/" + this.pathFaxSid + "/Media/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FaxMedia fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return FaxMedia.fromJson(response.getStream(), client.getObjectMapper());
    }
}

