/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.fax.v1.Fax;
import org.joda.time.DateTime;

public class FaxReader
extends Reader<Fax> {
    private String from;
    private String to;
    private DateTime dateCreatedOnOrBefore;
    private DateTime dateCreatedAfter;

    public FaxReader setFrom(String from) {
        this.from = from;
        return this;
    }

    public FaxReader setTo(String to) {
        this.to = to;
        return this;
    }

    public FaxReader setDateCreatedOnOrBefore(DateTime dateCreatedOnOrBefore) {
        this.dateCreatedOnOrBefore = dateCreatedOnOrBefore;
        return this;
    }

    public FaxReader setDateCreatedAfter(DateTime dateCreatedAfter) {
        this.dateCreatedAfter = dateCreatedAfter;
        return this;
    }

    @Override
    public ResourceSet<Fax> read(TwilioRestClient client) {
        return new ResourceSet<Fax>(this, client, this.firstPage(client));
    }

    @Override
    public Page<Fax> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.FAX.toString(), "/v1/Faxes", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fax> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fax> nextPage(Page<Fax> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FAX.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<Fax> previousPage(Page<Fax> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FAX.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<Fax> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fax read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("faxes", response.getContent(), Fax.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.from != null) {
            request.addQueryParam("From", this.from);
        }
        if (this.to != null) {
            request.addQueryParam("To", this.to);
        }
        if (this.dateCreatedOnOrBefore != null) {
            request.addQueryParam("DateCreatedOnOrBefore", this.dateCreatedOnOrBefore.toString());
        }
        if (this.dateCreatedAfter != null) {
            request.addQueryParam("DateCreatedAfter", this.dateCreatedAfter.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

