/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1.service;

import com.twilio.base.Creator;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.authy.v1.service.Entity;

public class EntityCreator
extends Creator<Entity> {
    private final String pathServiceSid;
    private final String identity;

    public EntityCreator(String pathServiceSid, String identity) {
        this.pathServiceSid = pathServiceSid;
        this.identity = identity;
    }

    @Override
    public Entity create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.AUTHY.toString(), "/v1/Services/" + this.pathServiceSid + "/Entities", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Entity creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Entity.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.identity != null) {
            request.addPostParam("Identity", this.identity);
        }
    }
}

