/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.authy.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.authy.v1.FormFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Form
extends Resource {
    private static final long serialVersionUID = 262438037114282L;
    private final FormTypes formType;
    private final Map<String, Object> forms;
    private final Map<String, Object> formMeta;
    private final URI url;

    public static FormFetcher fetcher(FormTypes pathFormType) {
        return new FormFetcher(pathFormType);
    }

    public static Form fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Form.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Form fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Form.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Form(@JsonProperty(value="form_type") FormTypes formType, @JsonProperty(value="forms") Map<String, Object> forms, @JsonProperty(value="form_meta") Map<String, Object> formMeta, @JsonProperty(value="url") URI url) {
        this.formType = formType;
        this.forms = forms;
        this.formMeta = formMeta;
        this.url = url;
    }

    public final FormTypes getFormType() {
        return this.formType;
    }

    public final Map<String, Object> getForms() {
        return this.forms;
    }

    public final Map<String, Object> getFormMeta() {
        return this.formMeta;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Form other = (Form)o;
        return Objects.equals((Object)this.formType, (Object)other.formType) && Objects.equals(this.forms, other.forms) && Objects.equals(this.formMeta, other.formMeta) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.formType, this.forms, this.formMeta, this.url});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("formType", (Object)this.formType).add("forms", this.forms).add("formMeta", this.formMeta).add("url", this.url).toString();
    }

    public static enum FormTypes {
        FORM_APP_PUSH("form-app-push"),
        FORM_SMS("form-sms"),
        FORM_TOTP("form-totp");

        private final String value;

        private FormTypes(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FormTypes forValue(String value) {
            return (FormTypes)Promoter.enumFromString((String)value, (Enum[])FormTypes.values());
        }
    }
}

