/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.api.v2010.account;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.CurrencyDeserializer;
import com.twilio.converter.DateConverter;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.api.v2010.account.MessageCreator;
import com.twilio.rest.api.v2010.account.MessageDeleter;
import com.twilio.rest.api.v2010.account.MessageFetcher;
import com.twilio.rest.api.v2010.account.MessageReader;
import com.twilio.rest.api.v2010.account.MessageUpdater;
import com.twilio.type.PhoneNumber;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Message
extends Resource {
    private static final long serialVersionUID = 61377418909039L;
    private final String accountSid;
    private final String apiVersion;
    private final String body;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final DateTime dateSent;
    private final Direction direction;
    private final Integer errorCode;
    private final String errorMessage;
    private final PhoneNumber from;
    private final String messagingServiceSid;
    private final String numMedia;
    private final String numSegments;
    private final BigDecimal price;
    private final Currency priceUnit;
    private final String sid;
    private final Status status;
    private final Map<String, String> subresourceUris;
    private final String to;
    private final String uri;

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, PhoneNumber from, String body) {
        return new MessageCreator(pathAccountSid, to, from, body);
    }

    public static MessageCreator creator(PhoneNumber to, PhoneNumber from, String body) {
        return new MessageCreator(to, from, body);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new MessageCreator(pathAccountSid, to, from, mediaUrl);
    }

    public static MessageCreator creator(PhoneNumber to, PhoneNumber from, List<URI> mediaUrl) {
        return new MessageCreator(to, from, mediaUrl);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, String body) {
        return new MessageCreator(pathAccountSid, to, messagingServiceSid, body);
    }

    public static MessageCreator creator(PhoneNumber to, String messagingServiceSid, String body) {
        return new MessageCreator(to, messagingServiceSid, body);
    }

    public static MessageCreator creator(String pathAccountSid, PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        return new MessageCreator(pathAccountSid, to, messagingServiceSid, mediaUrl);
    }

    public static MessageCreator creator(PhoneNumber to, String messagingServiceSid, List<URI> mediaUrl) {
        return new MessageCreator(to, messagingServiceSid, mediaUrl);
    }

    public static MessageDeleter deleter(String pathAccountSid, String pathSid) {
        return new MessageDeleter(pathAccountSid, pathSid);
    }

    public static MessageDeleter deleter(String pathSid) {
        return new MessageDeleter(pathSid);
    }

    public static MessageFetcher fetcher(String pathAccountSid, String pathSid) {
        return new MessageFetcher(pathAccountSid, pathSid);
    }

    public static MessageFetcher fetcher(String pathSid) {
        return new MessageFetcher(pathSid);
    }

    public static MessageReader reader(String pathAccountSid) {
        return new MessageReader(pathAccountSid);
    }

    public static MessageReader reader() {
        return new MessageReader();
    }

    public static MessageUpdater updater(String pathAccountSid, String pathSid, String body) {
        return new MessageUpdater(pathAccountSid, pathSid, body);
    }

    public static MessageUpdater updater(String pathSid, String body) {
        return new MessageUpdater(pathSid, body);
    }

    public static Message fromJson(String json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Message fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return objectMapper.readValue(json, Message.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Message(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="api_version") String apiVersion, @JsonProperty(value="body") String body, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="date_sent") String dateSent, @JsonProperty(value="direction") Direction direction, @JsonProperty(value="error_code") Integer errorCode, @JsonProperty(value="error_message") String errorMessage, @JsonProperty(value="from") PhoneNumber from, @JsonProperty(value="messaging_service_sid") String messagingServiceSid, @JsonProperty(value="num_media") String numMedia, @JsonProperty(value="num_segments") String numSegments, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price_unit") @JsonDeserialize(using=CurrencyDeserializer.class) Currency priceUnit, @JsonProperty(value="sid") String sid, @JsonProperty(value="status") Status status, @JsonProperty(value="subresource_uris") Map<String, String> subresourceUris, @JsonProperty(value="to") String to, @JsonProperty(value="uri") String uri) {
        this.accountSid = accountSid;
        this.apiVersion = apiVersion;
        this.body = body;
        this.dateCreated = DateConverter.rfc2822DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.rfc2822DateTimeFromString(dateUpdated);
        this.dateSent = DateConverter.rfc2822DateTimeFromString(dateSent);
        this.direction = direction;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.from = from;
        this.messagingServiceSid = messagingServiceSid;
        this.numMedia = numMedia;
        this.numSegments = numSegments;
        this.price = price;
        this.priceUnit = priceUnit;
        this.sid = sid;
        this.status = status;
        this.subresourceUris = subresourceUris;
        this.to = to;
        this.uri = uri;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getApiVersion() {
        return this.apiVersion;
    }

    public final String getBody() {
        return this.body;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final DateTime getDateSent() {
        return this.dateSent;
    }

    public final Direction getDirection() {
        return this.direction;
    }

    public final Integer getErrorCode() {
        return this.errorCode;
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final PhoneNumber getFrom() {
        return this.from;
    }

    public final String getMessagingServiceSid() {
        return this.messagingServiceSid;
    }

    public final String getNumMedia() {
        return this.numMedia;
    }

    public final String getNumSegments() {
        return this.numSegments;
    }

    public final BigDecimal getPrice() {
        return this.price;
    }

    public final Currency getPriceUnit() {
        return this.priceUnit;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Map<String, String> getSubresourceUris() {
        return this.subresourceUris;
    }

    public final String getTo() {
        return this.to;
    }

    public final String getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message other = (Message)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.apiVersion, other.apiVersion) && Objects.equals(this.body, other.body) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.dateSent, other.dateSent) && Objects.equals((Object)this.direction, (Object)other.direction) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.from, other.from) && Objects.equals(this.messagingServiceSid, other.messagingServiceSid) && Objects.equals(this.numMedia, other.numMedia) && Objects.equals(this.numSegments, other.numSegments) && Objects.equals(this.price, other.price) && Objects.equals(this.priceUnit, other.priceUnit) && Objects.equals(this.sid, other.sid) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.subresourceUris, other.subresourceUris) && Objects.equals(this.to, other.to) && Objects.equals(this.uri, other.uri);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountSid, this.apiVersion, this.body, this.dateCreated, this.dateUpdated, this.dateSent, this.direction, this.errorCode, this.errorMessage, this.from, this.messagingServiceSid, this.numMedia, this.numSegments, this.price, this.priceUnit, this.sid, this.status, this.subresourceUris, this.to, this.uri});
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("accountSid", this.accountSid).add("apiVersion", this.apiVersion).add("body", this.body).add("dateCreated", this.dateCreated).add("dateUpdated", this.dateUpdated).add("dateSent", this.dateSent).add("direction", (Object)this.direction).add("errorCode", this.errorCode).add("errorMessage", this.errorMessage).add("from", this.from).add("messagingServiceSid", this.messagingServiceSid).add("numMedia", this.numMedia).add("numSegments", this.numSegments).add("price", this.price).add("priceUnit", this.priceUnit).add("sid", this.sid).add("status", (Object)this.status).add("subresourceUris", this.subresourceUris).add("to", this.to).add("uri", this.uri).toString();
    }

    public static enum AddressRetention {
        RETAIN("retain"),
        DISCARD("discard");

        private final String value;

        private AddressRetention(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static AddressRetention forValue(String value) {
            return (AddressRetention)Promoter.enumFromString((String)value, (Enum[])AddressRetention.values());
        }
    }

    public static enum ContentRetention {
        RETAIN("retain"),
        DISCARD("discard");

        private final String value;

        private ContentRetention(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static ContentRetention forValue(String value) {
            return (ContentRetention)Promoter.enumFromString((String)value, (Enum[])ContentRetention.values());
        }
    }

    public static enum Direction {
        INBOUND("inbound"),
        OUTBOUND_API("outbound-api"),
        OUTBOUND_CALL("outbound-call"),
        OUTBOUND_REPLY("outbound-reply");

        private final String value;

        private Direction(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Direction forValue(String value) {
            return (Direction)Promoter.enumFromString((String)value, (Enum[])Direction.values());
        }
    }

    public static enum Status {
        QUEUED("queued"),
        SENDING("sending"),
        SENT("sent"),
        FAILED("failed"),
        DELIVERED("delivered"),
        UNDELIVERED("undelivered"),
        RECEIVING("receiving"),
        RECEIVED("received"),
        ACCEPTED("accepted");

        private final String value;

        private Status(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Status forValue(String value) {
            return (Status)Promoter.enumFromString((String)value, (Enum[])Status.values());
        }
    }
}

