/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.jwt.client;

import com.google.common.base.Joiner;
import com.twilio.jwt.client.Scope;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class EventStreamScope
implements Scope {
    private static final String SCOPE = Joiner.on(':').join("scope", "stream", "subscribe");
    private final Map<String, String> filters;

    private EventStreamScope(Builder b) {
        this.filters = b.filters;
    }

    @Override
    public String getPayload() throws UnsupportedEncodingException {
        ArrayList<String> queryArgs = new ArrayList<String>();
        queryArgs.add("path=/2010-04-01/Events");
        if (!this.filters.isEmpty()) {
            queryArgs.add(Joiner.on('=').join(URLEncoder.encode("appParams", "UTF-8"), URLEncoder.encode(this.getFilterParams(), "UTF-8"), new Object[0]));
        }
        String queryString = Joiner.on('&').join(queryArgs);
        return Joiner.on('?').join(SCOPE, queryString, new Object[0]);
    }

    private String getFilterParams() throws UnsupportedEncodingException {
        ArrayList<String> queryParams = new ArrayList<String>();
        for (Map.Entry<String, String> param : this.filters.entrySet()) {
            queryParams.add(Joiner.on('=').join(URLEncoder.encode(param.getKey(), "UTF-8"), URLEncoder.encode(param.getValue(), "UTF-8"), new Object[0]));
        }
        return Joiner.on('&').join(queryParams);
    }

    public static class Builder {
        private Map<String, String> filters = new HashMap<String, String>();

        public Builder filters(Map<String, String> filters) {
            this.filters.putAll(filters);
            return this;
        }

        public EventStreamScope build() {
            return new EventStreamScope(this);
        }
    }
}

