/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.http;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.twilio.Twilio;
import com.twilio.exception.ApiException;
import com.twilio.http.HttpClient;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

public class NetworkHttpClient
extends HttpClient {
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final int SOCKET_TIMEOUT = 30500;
    private final org.apache.http.client.HttpClient client;

    public NetworkHttpClient() {
        RequestConfig config = RequestConfig.custom().setConnectTimeout(10000).setSocketTimeout(30500).build();
        ArrayList<Header> headers = Lists.newArrayList(new BasicHeader("X-Twilio-Client", "java-7.34.1"), new BasicHeader("User-Agent", "twilio-java/7.34.1 (" + Twilio.JAVA_VERSION + ")"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        String googleAppEngineVersion = System.getProperty("com.google.appengine.runtime.version");
        boolean isNotGoogleAppEngine = Strings.isNullOrEmpty(googleAppEngineVersion);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        if (isNotGoogleAppEngine) {
            clientBuilder.useSystemProperties();
        }
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager();
        connectionManager.setDefaultMaxPerRoute(10);
        connectionManager.setMaxTotal(20);
        clientBuilder.setConnectionManager(connectionManager).setDefaultRequestConfig(config).setDefaultHeaders(headers);
        this.client = clientBuilder.build();
    }

    public NetworkHttpClient(HttpClientBuilder clientBuilder) {
        ArrayList<Header> headers = Lists.newArrayList(new BasicHeader("X-Twilio-Client", "java-7.34.1"), new BasicHeader("User-Agent", "twilio-java/7.34.1 (" + Twilio.JAVA_VERSION + ") custom"), new BasicHeader("Accept", "application/json"), new BasicHeader("Accept-Encoding", "utf-8"));
        this.client = clientBuilder.setDefaultHeaders(headers).build();
    }

    @Override
    public Response makeRequest(Request request) {
        Response response;
        HttpMethod method = request.getMethod();
        RequestBuilder builder = RequestBuilder.create(method.toString()).setUri(request.constructURL().toString()).setVersion(HttpVersion.HTTP_1_1).setCharset(StandardCharsets.UTF_8);
        if (request.requiresAuthentication()) {
            builder.addHeader("Authorization", request.getAuthString());
        }
        if (method == HttpMethod.POST) {
            builder.addHeader("Content-Type", "application/x-www-form-urlencoded");
            for (Map.Entry<String, List<String>> entry : request.getPostParams().entrySet()) {
                for (String value : entry.getValue()) {
                    builder.addParameter(entry.getKey(), value);
                }
            }
        }
        HttpResponse response2 = null;
        try {
            response2 = this.client.execute(builder.build());
            HttpEntity entity = response2.getEntity();
            response = new Response(entity == null ? null : new BufferedHttpEntity(entity).getContent(), response2.getStatusLine().getStatusCode());
        }
        catch (IOException e) {
            try {
                throw new ApiException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                HttpClientUtils.closeQuietly(response2);
                throw throwable;
            }
        }
        HttpClientUtils.closeQuietly(response2);
        return response;
    }
}

