/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.sqs.model.ChangeMessageVisibilityBatchRequestEntry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeMessageVisibilityBatchRequest
extends AmazonWebServiceRequest
implements Serializable {
    private String queueUrl;
    private List<ChangeMessageVisibilityBatchRequestEntry> entries;

    public ChangeMessageVisibilityBatchRequest() {
    }

    public ChangeMessageVisibilityBatchRequest(String queueUrl, List<ChangeMessageVisibilityBatchRequestEntry> entries) {
        this.queueUrl = queueUrl;
        this.entries = entries;
    }

    public String getQueueUrl() {
        return this.queueUrl;
    }

    public void setQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
    }

    public ChangeMessageVisibilityBatchRequest withQueueUrl(String queueUrl) {
        this.queueUrl = queueUrl;
        return this;
    }

    public List<ChangeMessageVisibilityBatchRequestEntry> getEntries() {
        if (this.entries == null) {
            this.entries = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>();
        }
        return this.entries;
    }

    public void setEntries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
            return;
        }
        ArrayList<ChangeMessageVisibilityBatchRequestEntry> entriesCopy = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(entries.size());
        entriesCopy.addAll(entries);
        this.entries = entriesCopy;
    }

    public ChangeMessageVisibilityBatchRequest withEntries(ChangeMessageVisibilityBatchRequestEntry ... entries) {
        if (this.getEntries() == null) {
            this.setEntries(new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(entries.length));
        }
        for (ChangeMessageVisibilityBatchRequestEntry value : entries) {
            this.getEntries().add(value);
        }
        return this;
    }

    public ChangeMessageVisibilityBatchRequest withEntries(Collection<ChangeMessageVisibilityBatchRequestEntry> entries) {
        if (entries == null) {
            this.entries = null;
        } else {
            ArrayList<ChangeMessageVisibilityBatchRequestEntry> entriesCopy = new ArrayList<ChangeMessageVisibilityBatchRequestEntry>(entries.size());
            entriesCopy.addAll(entries);
            this.entries = entriesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getQueueUrl() != null) {
            sb.append("QueueUrl: " + this.getQueueUrl() + ", ");
        }
        if (this.getEntries() != null) {
            sb.append("Entries: " + this.getEntries() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getQueueUrl() == null ? 0 : this.getQueueUrl().hashCode());
        hashCode = 31 * hashCode + (this.getEntries() == null ? 0 : ((Object)this.getEntries()).hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeMessageVisibilityBatchRequest)) {
            return false;
        }
        ChangeMessageVisibilityBatchRequest other = (ChangeMessageVisibilityBatchRequest)obj;
        if (other.getQueueUrl() == null ^ this.getQueueUrl() == null) {
            return false;
        }
        if (other.getQueueUrl() != null && !other.getQueueUrl().equals(this.getQueueUrl())) {
            return false;
        }
        if (other.getEntries() == null ^ this.getEntries() == null) {
            return false;
        }
        return other.getEntries() == null || ((Object)other.getEntries()).equals(this.getEntries());
    }
}

