/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodb.model;

import com.amazonaws.services.dynamodb.model.AttributeValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchResponse
implements Serializable {
    private List<Map<String, AttributeValue>> items;
    private Double consumedCapacityUnits;

    public List<Map<String, AttributeValue>> getItems() {
        return this.items;
    }

    public void setItems(Collection<Map<String, AttributeValue>> items) {
        if (items == null) {
            this.items = null;
            return;
        }
        ArrayList<Map<String, AttributeValue>> itemsCopy = new ArrayList<Map<String, AttributeValue>>(items.size());
        itemsCopy.addAll(items);
        this.items = itemsCopy;
    }

    public BatchResponse withItems(Map<String, AttributeValue> ... items) {
        if (this.getItems() == null) {
            this.setItems(new ArrayList<Map<String, AttributeValue>>(items.length));
        }
        for (Map<String, AttributeValue> value : items) {
            this.getItems().add(value);
        }
        return this;
    }

    public BatchResponse withItems(Collection<Map<String, AttributeValue>> items) {
        if (items == null) {
            this.items = null;
        } else {
            ArrayList<Map<String, AttributeValue>> itemsCopy = new ArrayList<Map<String, AttributeValue>>(items.size());
            itemsCopy.addAll(items);
            this.items = itemsCopy;
        }
        return this;
    }

    public Double getConsumedCapacityUnits() {
        return this.consumedCapacityUnits;
    }

    public void setConsumedCapacityUnits(Double consumedCapacityUnits) {
        this.consumedCapacityUnits = consumedCapacityUnits;
    }

    public BatchResponse withConsumedCapacityUnits(Double consumedCapacityUnits) {
        this.consumedCapacityUnits = consumedCapacityUnits;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getItems() != null) {
            sb.append("Items: " + this.getItems() + ", ");
        }
        if (this.getConsumedCapacityUnits() != null) {
            sb.append("ConsumedCapacityUnits: " + this.getConsumedCapacityUnits() + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getItems() == null ? 0 : ((Object)this.getItems()).hashCode());
        hashCode = 31 * hashCode + (this.getConsumedCapacityUnits() == null ? 0 : this.getConsumedCapacityUnits().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchResponse)) {
            return false;
        }
        BatchResponse other = (BatchResponse)obj;
        if (other.getItems() == null ^ this.getItems() == null) {
            return false;
        }
        if (other.getItems() != null && !((Object)other.getItems()).equals(this.getItems())) {
            return false;
        }
        if (other.getConsumedCapacityUnits() == null ^ this.getConsumedCapacityUnits() == null) {
            return false;
        }
        return other.getConsumedCapacityUnits() == null || other.getConsumedCapacityUnits().equals(this.getConsumedCapacityUnits());
    }
}

