/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.utils.reflection;

public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoaderUtils.class.getClassLoader();
        }
        return cl;
    }

    public static Class<?> classForName(String name) throws ClassNotFoundException {
        ClassLoader cl = ClassLoaderUtils.getClassLoader();
        try {
            if (cl != null) {
                return cl.loadClass(name);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return Class.forName(name);
    }
}

