/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.SessionFactory;

public final class ConfigurationHelper {
    private static ThreadLocal<SessionFactory> currentSessionFactory = new ThreadLocal();
    private static final Map<SessionFactory, Properties> DEFAULT_PROPERTIES = new HashMap<SessionFactory, Properties>();

    private ConfigurationHelper() {
    }

    public static String getProperty(String key) {
        Properties defaults;
        SessionFactory current = currentSessionFactory.get();
        if (current != null && (defaults = DEFAULT_PROPERTIES.get(current)) != null) {
            return defaults.getProperty(key);
        }
        return null;
    }

    static void setCurrentSessionFactory(SessionFactory sessionFactory) {
        currentSessionFactory.set(sessionFactory);
    }

    static void configureDefaultProperties(SessionFactory sessionFactory, Properties properties) {
        if (properties == null) {
            DEFAULT_PROPERTIES.remove(sessionFactory);
        } else {
            DEFAULT_PROPERTIES.put(sessionFactory, properties);
        }
    }
}

