/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.spi.shared;

import java.util.Comparator;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.usertype.ParameterizedType;
import org.hibernate.usertype.UserVersionType;
import org.jadira.usertype.spi.shared.AbstractParameterizedUserType;
import org.jadira.usertype.spi.shared.ConfigurationHelper;
import org.jadira.usertype.spi.shared.IntegratorConfiguredType;
import org.jadira.usertype.spi.shared.Seed;
import org.jadira.usertype.spi.shared.VersionableColumnMapper;

public abstract class AbstractVersionableUserType<T, J, C extends VersionableColumnMapper<T, J>>
extends AbstractParameterizedUserType<T, J, C>
implements UserVersionType,
Comparator,
ParameterizedType,
IntegratorConfiguredType {
    private static final long serialVersionUID = -8127535032447082933L;
    private Seed<J> seed;

    @Override
    public void applyConfiguration(SessionFactory sessionFactory) {
        super.applyConfiguration(sessionFactory);
        if (this.seed == null) {
            String seedName = null;
            if (this.getParameterValues() != null) {
                seedName = this.getParameterValues().getProperty("seed");
            }
            if (seedName == null) {
                seedName = ConfigurationHelper.getProperty("seed");
            }
            if (seedName != null) {
                Class<?> seedClass;
                try {
                    Class<?> mySeedClass;
                    seedClass = mySeedClass = Class.forName(seedName);
                }
                catch (ClassNotFoundException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be found");
                }
                try {
                    this.seed = (Seed)seedClass.newInstance();
                }
                catch (InstantiationException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be instantiated");
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalStateException("Referenced seed class {" + seedName + "} cannot be accessed");
                }
            }
        }
    }

    public abstract int compare(Object var1, Object var2);

    public T seed(SessionImplementor session) {
        VersionableColumnMapper columnMapper = (VersionableColumnMapper)this.getColumnMapper();
        if (this.seed == null) {
            return columnMapper.fromNonNullValue(columnMapper.generateCurrentValue());
        }
        return columnMapper.fromNonNullValue(this.seed.getTimestamp(session));
    }

    public T next(Object current, SessionImplementor session) {
        return this.seed(session);
    }
}

