/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.unitsofmeasurement.indriya;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.spi.ServiceProvider;
import javax.measure.spi.SystemOfUnitsService;
import org.hibernate.SessionFactory;
import org.jadira.usertype.spi.shared.AbstractParameterizedUserType;
import org.jadira.usertype.spi.shared.ValidTypesConfigured;
import org.jadira.usertype.spi.utils.reflection.ClassLoaderUtils;
import org.jadira.usertype.unitsofmeasurement.indriya.columnmapper.StringColumnQuantityMapper;
import org.jadira.usertype.unitsofmeasurement.indriya.util.UnitConfigured;

public class PersistentQuantity<Q extends Quantity<Q>>
extends AbstractParameterizedUserType<Q, String, StringColumnQuantityMapper<Q>>
implements ValidTypesConfigured<Unit<?>> {
    private static final long serialVersionUID = -2015829087239519037L;
    private static final Map<String, Unit<?>> BASE_UNITS_MAP = new HashMap();
    private static SystemOfUnitsService SYSTEM_OF_UNITS_SERVICE = ServiceProvider.current().getSystemOfUnitsService();
    private static final Map<String, Unit<?>> unitsMap;
    private List<Class<Unit<?>>> validTypes;

    public void applyConfiguration(SessionFactory sessionFactory) {
        super.applyConfiguration(sessionFactory);
        this.doApplyConfiguration();
    }

    private <Z> void doApplyConfiguration() {
        PersistentQuantity next = this;
        this.performValidTypesConfiguration(next);
        if (UnitConfigured.class.isAssignableFrom(((StringColumnQuantityMapper)this.getColumnMapper()).getClass())) {
            UnitConfigured unitConfigured = (UnitConfigured)this.getColumnMapper();
            this.performUnitConfiguration(unitConfigured);
        }
    }

    private void performUnitConfiguration(UnitConfigured<?> unitConfigured) {
        String unitString = null;
        if (this.getParameterValues() != null) {
            unitString = this.getParameterValues().getProperty("unit");
        }
        if (unitString != null) {
            try {
                Unit unit = BASE_UNITS_MAP.get(unitString);
                if (unit == null) {
                    unit = unitsMap.get(unitString);
                }
                if (unit == null) {
                    Unit myUnit;
                    Class unitClass = ClassLoaderUtils.classForName((String)unitString);
                    unit = myUnit = (Unit)unitClass.newInstance();
                }
                ((StringColumnQuantityMapper)unitConfigured).setUnit(unit);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Cannot find specified class or unit " + unitString, e);
            }
        }
    }

    private void performValidTypesConfiguration(ValidTypesConfigured<Unit<?>> next) {
        String validTypesString = null;
        if (this.getParameterValues() != null) {
            validTypesString = this.getParameterValues().getProperty("validTypes");
        }
        if (validTypesString != null) {
            String[] validTypes = validTypesString.split(",");
            ArrayList<Class> units = new ArrayList<Class>();
            for (String nextType : validTypes) {
                try {
                    Class nextClass = ClassLoaderUtils.classForName((String)nextType);
                    units.add(nextClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Cannot find specified class " + nextType, e);
                }
            }
            next.setValidTypes(units);
        }
    }

    public void setValidTypes(List<Class<Unit<?>>> types) {
        for (Class<Unit<?>> next : types) {
            Unit<?> unit;
            try {
                unit = next.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Cannot instantiate " + next.getName() + ": " + e.getMessage(), e);
            }
            unitsMap.put(unit.getSymbol(), unit);
        }
        this.validTypes = Collections.unmodifiableList(types);
    }

    public List<Class<Unit<?>>> getValidTypes() {
        return this.validTypes;
    }

    static {
        for (Unit next : SYSTEM_OF_UNITS_SERVICE.getSystemOfUnits().getUnits()) {
            BASE_UNITS_MAP.put(next.getSymbol(), next);
        }
        unitsMap = new HashMap();
    }
}

