/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.threeten.columnmapper;

import java.math.BigInteger;
import java.time.Duration;
import org.jadira.usertype.spi.shared.AbstractBigIntegerColumnMapper;

public class BigIntegerColumnDurationMapper
extends AbstractBigIntegerColumnMapper<Duration> {
    private static final long serialVersionUID = 8408450977695192938L;
    private static final BigInteger NANOS_IN_SECOND = BigInteger.valueOf(1000000000L);

    public Duration fromNonNullString(String s) {
        return Duration.parse(s);
    }

    public Duration fromNonNullValue(BigInteger value) {
        return Duration.ofSeconds(value.divide(NANOS_IN_SECOND).longValue(), value.remainder(NANOS_IN_SECOND).longValue());
    }

    public String toNonNullString(Duration value) {
        return value.toString();
    }

    public BigInteger toNonNullValue(Duration value) {
        return BigInteger.valueOf(value.getNano()).add(BigInteger.valueOf(value.getSeconds()).multiply(NANOS_IN_SECOND));
    }
}

