/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.legacyjdk.columnmapper;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.TimeZone;
import org.jadira.usertype.spi.shared.AbstractVersionableTimestampColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;

public class TimestampColumnTimestampMapper
extends AbstractVersionableTimestampColumnMapper<Timestamp>
implements DatabaseZoneConfigured<TimeZone> {
    private static final long serialVersionUID = -7670411089210984705L;
    private static final ThreadLocal<SimpleDateFormat> DATETIME_FORMAT = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            return format;
        }
    };
    private TimeZone databaseZone = TimeZone.getTimeZone("GMT");

    public TimestampColumnTimestampMapper() {
    }

    public TimestampColumnTimestampMapper(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public Timestamp fromNonNullString(String s) {
        return Timestamp.valueOf(s);
    }

    public Timestamp fromNonNullValue(Timestamp value) {
        Timestamp timestamp = new Timestamp(value.getTime());
        timestamp.setNanos(value.getNanos());
        return timestamp;
    }

    public String toNonNullString(Timestamp value) {
        String tsString;
        TimeZone gmtZone = TimeZone.getTimeZone("GMT");
        SimpleDateFormat sdf = DATETIME_FORMAT.get();
        sdf.setTimeZone(gmtZone);
        Calendar now = Calendar.getInstance(gmtZone);
        now.clear();
        now.setTime(value);
        long milliseconds = now.get(14);
        if (milliseconds > 0L) {
            tsString = sdf.format(value);
        } else {
            String nanosString = "" + milliseconds + "000000000";
            nanosString = nanosString.substring(0, 9);
            tsString = sdf.format(value) + "." + nanosString;
        }
        return tsString;
    }

    public Timestamp toNonNullValue(Timestamp value) {
        Timestamp timestamp = new Timestamp(value.getTime());
        timestamp.setNanos(value.getNanos());
        return timestamp;
    }

    public void setDatabaseZone(TimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public TimeZone parseZone(String zoneString) {
        return TimeZone.getTimeZone(zoneString);
    }

    public final DstSafeTimestampType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimestampType.INSTANCE : new DstSafeTimestampType(Calendar.getInstance(this.databaseZone));
    }
}

