/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda.columnmapper;

import java.sql.Timestamp;
import java.util.Calendar;
import org.jadira.usertype.spi.shared.AbstractTimestampColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.shared.DstSafeTimestampType;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.LocalTime;
import org.joda.time.TimeOfDay;

public class TimestampColumnTimeOfDayMapper
extends AbstractTimestampColumnMapper<TimeOfDay>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 1921591625617366103L;
    private DateTimeZone databaseZone = null;

    public TimestampColumnTimeOfDayMapper() {
    }

    public TimestampColumnTimeOfDayMapper(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public TimeOfDay fromNonNullString(String s) {
        return new TimeOfDay((Object)s);
    }

    public TimeOfDay fromNonNullValue(Timestamp value) {
        DateTime dateTime = new DateTime(value.getTime());
        LocalTime localTime = dateTime.toLocalTime();
        TimeOfDay timeOfDay = new TimeOfDay(localTime.getHourOfDay(), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getMillisOfSecond(), localTime.getChronology());
        return timeOfDay;
    }

    public String toNonNullString(TimeOfDay value) {
        return value.toString();
    }

    public Timestamp toNonNullValue(TimeOfDay value) {
        DateTime zonedValue = new LocalDateTime(1970, 1, 1, value.getHourOfDay(), value.getMinuteOfHour(), value.getSecondOfMinute(), value.getMillisOfSecond(), value.getChronology()).toDateTime();
        Timestamp timestamp = new Timestamp(zonedValue.getMillis());
        return timestamp;
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }

    public final DstSafeTimestampType getHibernateType() {
        return this.databaseZone == null ? DstSafeTimestampType.INSTANCE : new DstSafeTimestampType(Calendar.getInstance(this.databaseZone.toTimeZone()));
    }
}

