/*
 * Decompiled with CFR 0.152.
 */
package org.jadira.usertype.dateandtime.joda;

import org.jadira.usertype.dateandtime.joda.columnmapper.StringColumnDateTimeZoneMapper;
import org.jadira.usertype.dateandtime.joda.columnmapper.TimestampColumnLocalDateTimeMapper;
import org.jadira.usertype.spi.shared.AbstractParameterizedMultiColumnUserType;
import org.jadira.usertype.spi.shared.ColumnMapper;
import org.jadira.usertype.spi.shared.DatabaseZoneConfigured;
import org.jadira.usertype.spi.utils.reflection.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;

public class PersistentDateTimeAndZone
extends AbstractParameterizedMultiColumnUserType<DateTime>
implements DatabaseZoneConfigured<DateTimeZone> {
    private static final long serialVersionUID = 1364221029392346011L;
    private static final ColumnMapper<?, ?>[] COLUMN_MAPPERS = new ColumnMapper[]{new TimestampColumnLocalDateTimeMapper(), new StringColumnDateTimeZoneMapper()};
    private static final String[] PROPERTY_NAMES = new String[]{"datetime", "offset"};
    private DateTimeZone databaseZone = DateTimeZone.UTC;

    protected DateTime fromConvertedColumns(Object[] convertedColumns) {
        DateTime result;
        LocalDateTime datePart = (LocalDateTime)convertedColumns[0];
        DateTimeZone zone = (DateTimeZone)convertedColumns[1];
        if (datePart == null) {
            result = null;
        } else {
            result = datePart.toDateTime(this.databaseZone == null ? zone : this.databaseZone);
            if (this.databaseZone != null) {
                result = result.withZone(zone);
            }
        }
        return result;
    }

    protected Object[] toConvertedColumns(DateTime value) {
        DateTime myValue = this.databaseZone == null ? value : value.withZone(this.databaseZone);
        return new Object[]{myValue.toLocalDateTime(), value.getZone()};
    }

    public void setDatabaseZone(DateTimeZone databaseZone) {
        this.databaseZone = databaseZone;
    }

    public DateTimeZone parseZone(String zoneString) {
        return DateTimeZone.forID((String)zoneString);
    }

    protected ColumnMapper<?, ?>[] getColumnMappers() {
        return COLUMN_MAPPERS;
    }

    public String[] getPropertyNames() {
        return (String[])ArrayUtils.copyOf((Object[])PROPERTY_NAMES);
    }
}

