/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.Task;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Enqueue
extends TwiML {
    private final URI action;
    private final HttpMethod method;
    private final URI waitUrl;
    private final HttpMethod waitUrlMethod;
    private final String workflowSid;
    private final String name;

    private Enqueue() {
        this(new Builder());
    }

    private Enqueue(Builder b) {
        super("Enqueue", b);
        this.action = b.action;
        this.method = b.method;
        this.waitUrl = b.waitUrl;
        this.waitUrlMethod = b.waitUrlMethod;
        this.workflowSid = b.workflowSid;
        this.name = b.name;
    }

    @Override
    protected String getElementBody() {
        return this.getName() == null ? null : this.getName();
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        if (this.getWaitUrl() != null) {
            attrs.put("waitUrl", this.getWaitUrl().toString());
        }
        if (this.getWaitUrlMethod() != null) {
            attrs.put("waitUrlMethod", this.getWaitUrlMethod().toString());
        }
        if (this.getWorkflowSid() != null) {
            attrs.put("workflowSid", this.getWorkflowSid());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public URI getWaitUrl() {
        return this.waitUrl;
    }

    public HttpMethod getWaitUrlMethod() {
        return this.waitUrlMethod;
    }

    public String getWorkflowSid() {
        return this.workflowSid;
    }

    public String getName() {
        return this.name;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;
        private URI waitUrl;
        private HttpMethod waitUrlMethod;
        private String workflowSid;
        private String name;

        public Builder(String name) {
            this.name = name;
        }

        public Builder() {
        }

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder waitUrl(URI waitUrl) {
            this.waitUrl = waitUrl;
            return this;
        }

        public Builder waitUrl(String waitUrl) {
            this.waitUrl = Promoter.uriFromString(waitUrl);
            return this;
        }

        public Builder waitUrlMethod(HttpMethod waitUrlMethod) {
            this.waitUrlMethod = waitUrlMethod;
            return this;
        }

        public Builder workflowSid(String workflowSid) {
            this.workflowSid = workflowSid;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder task(Task task) {
            this.children.add(task);
            return this;
        }

        public Enqueue build() {
            return new Enqueue(this);
        }
    }
}

