/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.wireless.v1.sim;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.wireless.v1.sim.DataSession;
import org.joda.time.DateTime;

public class DataSessionReader
extends Reader<DataSession> {
    private final String pathSimSid;
    private DateTime end;
    private DateTime start;

    public DataSessionReader(String pathSimSid) {
        this.pathSimSid = pathSimSid;
    }

    public DataSessionReader setEnd(DateTime end) {
        this.end = end;
        return this;
    }

    public DataSessionReader setStart(DateTime start) {
        this.start = start;
        return this;
    }

    @Override
    public ResourceSet<DataSession> read(TwilioRestClient client) {
        return new ResourceSet<DataSession>(this, client, this.firstPage(client));
    }

    @Override
    public Page<DataSession> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.WIRELESS.toString(), "/v1/Sims/" + this.pathSimSid + "/DataSessions", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DataSession> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DataSession> nextPage(Page<DataSession> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.WIRELESS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<DataSession> previousPage(Page<DataSession> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.WIRELESS.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<DataSession> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("DataSession read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("data_sessions", response.getContent(), DataSession.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.end != null) {
            request.addQueryParam("End", this.end.toString());
        }
        if (this.start != null) {
            request.addQueryParam("Start", this.start.toString());
        }
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

