/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.accSecurity;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.accSecurity.Service;

public class ServiceUpdater
extends Updater<Service> {
    private final String pathSid;
    private String name;
    private Integer codeLength;

    public ServiceUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public ServiceUpdater setName(String name) {
        this.name = name;
        return this;
    }

    public ServiceUpdater setCodeLength(Integer codeLength) {
        this.codeLength = codeLength;
        return this;
    }

    @Override
    public Service update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.PREVIEW.toString(), "/Verification/Services/" + this.pathSid + "", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Service update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Service.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.name != null) {
            request.addPostParam("Name", this.name);
        }
        if (this.codeLength != null) {
            request.addPostParam("CodeLength", this.codeLength.toString());
        }
    }
}

