/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1.fax;

import com.twilio.base.Page;
import com.twilio.base.Reader;
import com.twilio.base.ResourceSet;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.fax.v1.fax.FaxMedia;

public class FaxMediaReader
extends Reader<FaxMedia> {
    private final String pathFaxSid;

    public FaxMediaReader(String pathFaxSid) {
        this.pathFaxSid = pathFaxSid;
    }

    @Override
    public ResourceSet<FaxMedia> read(TwilioRestClient client) {
        return new ResourceSet<FaxMedia>(this, client, this.firstPage(client));
    }

    @Override
    public Page<FaxMedia> firstPage(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.FAX.toString(), "/v1/Faxes/" + this.pathFaxSid + "/Media", client.getRegion());
        this.addQueryParams(request);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FaxMedia> getPage(String targetUrl, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, targetUrl);
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FaxMedia> nextPage(Page<FaxMedia> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getNextPageUrl(Domains.FAX.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    @Override
    public Page<FaxMedia> previousPage(Page<FaxMedia> page, TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, page.getPreviousPageUrl(Domains.FAX.toString(), client.getRegion()));
        return this.pageForRequest(client, request);
    }

    private Page<FaxMedia> pageForRequest(TwilioRestClient client, Request request) {
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FaxMedia read failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Page.fromJson("media", response.getContent(), FaxMedia.class, client.getObjectMapper());
    }

    private void addQueryParams(Request request) {
        if (this.getPageSize() != null) {
            request.addQueryParam("PageSize", Integer.toString(this.getPageSize()));
        }
    }
}

