/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.fax.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.fax.v1.Fax;
import java.net.URI;

public class FaxCreator
extends Creator<Fax> {
    private final String to;
    private final URI mediaUrl;
    private Fax.Quality quality;
    private URI statusCallback;
    private String from;
    private String sipAuthUsername;
    private String sipAuthPassword;
    private Boolean storeMedia;
    private Integer ttl;

    public FaxCreator(String to, URI mediaUrl) {
        this.to = to;
        this.mediaUrl = mediaUrl;
    }

    public FaxCreator setQuality(Fax.Quality quality) {
        this.quality = quality;
        return this;
    }

    public FaxCreator setStatusCallback(URI statusCallback) {
        this.statusCallback = statusCallback;
        return this;
    }

    public FaxCreator setStatusCallback(String statusCallback) {
        return this.setStatusCallback(Promoter.uriFromString(statusCallback));
    }

    public FaxCreator setFrom(String from) {
        this.from = from;
        return this;
    }

    public FaxCreator setSipAuthUsername(String sipAuthUsername) {
        this.sipAuthUsername = sipAuthUsername;
        return this;
    }

    public FaxCreator setSipAuthPassword(String sipAuthPassword) {
        this.sipAuthPassword = sipAuthPassword;
        return this;
    }

    public FaxCreator setStoreMedia(Boolean storeMedia) {
        this.storeMedia = storeMedia;
        return this;
    }

    public FaxCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public Fax create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.FAX.toString(), "/v1/Faxes", client.getRegion());
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Fax creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return Fax.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.to != null) {
            request.addPostParam("To", this.to);
        }
        if (this.mediaUrl != null) {
            request.addPostParam("MediaUrl", this.mediaUrl.toString());
        }
        if (this.quality != null) {
            request.addPostParam("Quality", this.quality.toString());
        }
        if (this.statusCallback != null) {
            request.addPostParam("StatusCallback", this.statusCallback.toString());
        }
        if (this.from != null) {
            request.addPostParam("From", this.from);
        }
        if (this.sipAuthUsername != null) {
            request.addPostParam("SipAuthUsername", this.sipAuthUsername);
        }
        if (this.sipAuthPassword != null) {
            request.addPostParam("SipAuthPassword", this.sipAuthPassword);
        }
        if (this.storeMedia != null) {
            request.addPostParam("StoreMedia", this.storeMedia.toString());
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
    }
}

