/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.chat.v2.service.channel;

import com.twilio.base.Deleter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.chat.v2.service.channel.Member;

public class MemberDeleter
extends Deleter<Member> {
    private final String pathServiceSid;
    private final String pathChannelSid;
    private final String pathSid;

    public MemberDeleter(String pathServiceSid, String pathChannelSid, String pathSid) {
        this.pathServiceSid = pathServiceSid;
        this.pathChannelSid = pathChannelSid;
        this.pathSid = pathSid;
    }

    @Override
    public boolean delete(TwilioRestClient client) {
        Request request = new Request(HttpMethod.DELETE, Domains.CHAT.toString(), "/v2/Services/" + this.pathServiceSid + "/Channels/" + this.pathChannelSid + "/Members/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Member delete failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return response.getStatusCode() == 204;
    }
}

