/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.autopilot.v1.assistant.fieldtype;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.autopilot.v1.assistant.fieldtype.FieldValue;

public class FieldValueFetcher
extends Fetcher<FieldValue> {
    private final String pathAssistantSid;
    private final String pathFieldTypeSid;
    private final String pathSid;

    public FieldValueFetcher(String pathAssistantSid, String pathFieldTypeSid, String pathSid) {
        this.pathAssistantSid = pathAssistantSid;
        this.pathFieldTypeSid = pathFieldTypeSid;
        this.pathSid = pathSid;
    }

    @Override
    public FieldValue fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.AUTOPILOT.toString(), "/v1/Assistants/" + this.pathAssistantSid + "/FieldTypes/" + this.pathFieldTypeSid + "/FieldValues/" + this.pathSid + "", client.getRegion());
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("FieldValue fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply(response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException.getMessage(), restException.getCode(), restException.getMoreInfo(), restException.getStatus(), null);
        }
        return FieldValue.fromJson(response.getStream(), client.getObjectMapper());
    }
}

